// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Phil Bradley





// Rosetta headers
#include <core/chemical/AtomType.hh>


// ObjexxFCL headers
//#include <ObjexxFCL/ObjexxFCL.hh>
//#include <ObjexxFCL/string.functions.hh>

// Numeric headers


// Utility headers
#include <utility/exit.hh>

// C++ headers


namespace core {
namespace chemical {

/// @details S-H bond length in CYS.
Real const MAX_CHEMICAL_BOND_TO_HYDROGEN_LENGTH = { 1.35 };


///////////////////////////////////////////////////////////////////////////////
/// @brief set LJ and LK solvation parameter for this atom type
///
/// @details currently parameters are "LJ_RADIUS","LJ_WDEPTH","LK_VOLUME",
/// "LK_DGFREE","LK_LAMBDA".It will abort if the parameter name is not
/// recoganized.
///
void
AtomType::set_parameter(
	std::string const & param,
	Real const setting
)
{
	if ( param == "LJ_RADIUS" ) {
		lj_radius_ = setting;
	} else if ( param == "LJ_WDEPTH" ) {
		lj_wdepth_ = setting;
	} else if ( param == "LK_VOLUME" ) {
		lk_volume_ = setting;
	} else if ( param == "LK_DGFREE" ) {
		lk_dgfree_ = setting;
	} else if ( param == "LK_LAMBDA" ) {
		lk_lambda_ = setting;
	} else {
		utility_exit_with_message( "unrecognized atomtype parameter "+param );
	}
}

///////////////////////////////////////////////////////////////////////////////
/// @brief set relevant properties for this atom type
///
/// @details currently properties are "ACCEPTOR","DONOR","POLAR_HYDROGEN",
/// "H2O", and hybridization types including "SP2_HYBRID", "SP3_HYBRID" and
/// "RING_HYBRID". It will abort if the property name is not recoganized.
///
void
AtomType::set_property(
	std::string const & property,
	bool const setting
)
{
	if ( property == "ACCEPTOR" ) {
		is_acceptor_ = setting;
	} else if ( property == "DONOR" ) {
		is_donor_ = setting;
	} else if ( property == "POLAR_HYDROGEN" ) {
		is_polar_hydrogen_ = setting;
	} else if ( property == "H2O" ) {
		is_h2o_ = setting;
	} else if ( property == "SP2_HYBRID" ) {
		hybridization_ = SP2_HYBRID;
	} else if ( property == "SP3_HYBRID" ) {
		hybridization_ = SP3_HYBRID;
	} else if ( property == "RING_HYBRID" ) {
		hybridization_ = RING_HYBRID;
	} else {
		utility_exit_with_message( "unrecognized atomtype property "+property );
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


} // pose
} // core
