// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file core/chemical/MMAtomTypeSet.cc
/// @brief
/// @author P. Douglas Renfrew (renfrew@unc.edu)

// Unit headers
#include <core/chemical/MMAtomTypeSet.hh>

// Project headers
#include <core/util/Tracer.hh>

// Utility headers
// Commented by inclean daemon #include <utility/exit.hh>

// C++ headers
// Commented by inclean daemon #include <string>
// Commented by inclean daemon #include <sstream>
#include <fstream>
#include <iostream>

namespace core {
namespace chemical {

static util::Tracer tr("core.chemical");


MMAtomTypeSet::MMAtomTypeSet():
	atom_type_index_(),
	atoms_()
{
}


MMAtomTypeSet::~MMAtomTypeSet() {}


/// @details Initialize an MMAtomTypeSet from an external file "filename",
/// and set parameters and properties for each MMAtomType.
/// Refer to minirosetta_database_stock/chemical/mm_atom_type_sets/fa_standard/mm_atom_properties.txt
/// for file format
///
void
MMAtomTypeSet::read_file( std::string const & filename )
{
	using namespace util;

	std::ifstream data( filename.c_str() ); // change to izstream!

	if ( !data.good() ) utility_exit_with_message( "Unable to open MMAtomTypeSet file: "+filename );

	std::string line, tag;
	while ( getline( data,line ) ) {
		std::istringstream l( line );
		l >> tag;
		if ( l.fail() ) {
			utility_exit_with_message("bad line: "+line);
		}

		std::string  name(tag); //( line.substr(0,4) );
		MMAtomType* mm_atom_type_ptr( new MMAtomType( name ) );


		// add this to the list
		atoms_.push_back( mm_atom_type_ptr );
		atom_type_index_[ name ] = atoms_.size();
		tr.Debug << "New MM atom type: " << name << std::endl;
	}

	tr.Debug << "MM atoms types added " << atoms_.size() << std::endl;
}

/// @details This function iterates over each element in the atom_type_index_ map and
/// prints both keys. It is only used for debugging.
void
MMAtomTypeSet::print_all_types()
{
	for( std::map< std::string, int >::const_iterator i = atom_type_index_.begin(), e = atom_type_index_.end(); i != e; ++i )
		{
			std::cout << (*i).first << " " << (*i).second << std::endl;
		}
}

} // chemical
} // core
