// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @author Phil Bradley

// // Unit headers
#include <core/chemical/VariantType.hh>

// // Package headers

// Project headers

// Utility headers
//#include <utility/vector1.hh>
//#include <utility/pointer/owning_ptr.hh>
//#include <utility/pointer/ReferenceCount.hh>

// C++ headers

namespace core {
namespace chemical {

	/// @brief C-terminus cap
VariantType const UPPER_TERMINUS( "UPPER_TERMINUS" );
	/// @brief N-terminus cap
VariantType const LOWER_TERMINUS( "LOWER_TERMINUS" );

	/// @brief for use during loop modeling, at positions before a cutpoint
VariantType const CUTPOINT_LOWER( "CUTPOINT_LOWER" );
	/// @brief for use during loop modeling, at positions after a cutpoint
VariantType const CUTPOINT_UPPER( "CUTPOINT_UPPER" );
	///
VariantType const DISULFIDE( "DISULFIDE" );
	///
VariantType const ADDUCT( "ADDUCT" );

VariantType const METHYLATION( "METHYLATION" );

VariantType const CENTROID_HA( "CENTROID_WITH_HA" );

// The following are added by Andy M. Chen in July 2009 to be used for PTM patches/variants
VariantType const PHOSPHORYLATION( "PHOSPHORYLATION" );
VariantType const ACETYLATION( "ACETYLATION" );
VariantType const SULFATION( "SULFATION" );
VariantType const CARBOXYLATION( "CARBOXYLATION" );
VariantType const HYDROXYLATION( "HYDROXYLATION" );
VariantType const DIMETHYLATION( "DIMETHYLATION" );
VariantType const TRIMETHYLATION( "TRIMETHYLATION" );
VariantType const DIIODINATION( "DIIODINATION" );


} // chemical
} // core
