// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
///
/// @brief
/// @author

#ifndef INCLUDED_core_chemical_util_HH
#define INCLUDED_core_chemical_util_HH


// Unit headers
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>

#include <core/conformation/Conformation.fwd.hh>

#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/chemical/VariantType.fwd.hh>
#include <core/chemical/ResidueType.fwd.hh>

namespace core {
namespace chemical {

/// POSE VERSIONS
void
replace_pose_residue_copying_existing_coordinates(
	pose::Pose & pose,
	Size const seqpos,
	ResidueType const & new_rsd_type
);


void
add_variant_type_to_pose_residue(
	pose::Pose & pose,
	VariantType const & variant_type,
	Size const seqpos
);


void
remove_variant_type_from_pose_residue(
	pose::Pose & pose,
	VariantType const & variant_type,
	Size const seqpos
);


void
add_lower_terminus_type_to_pose_residue(
	pose::Pose & pose,
	Size const seqpos
);


void
add_upper_terminus_type_to_pose_residue(
	pose::Pose & pose,
	Size const seqpos
);


void
remove_lower_terminus_type_from_pose_residue(
	pose::Pose & pose,
	Size const seqpos
);


void
remove_upper_terminus_type_from_pose_residue(
	pose::Pose & pose,
	Size const seqpos
);

/// CONFORMATION VERSIONS (is this hacky??)
void
replace_conformation_residue_copying_existing_coordinates(
	conformation::Conformation & conformation,
	Size const seqpos,
	ResidueType const & new_rsd_type
);


void
add_variant_type_to_conformation_residue(
	conformation::Conformation & conformation,
	VariantType const & variant_type,
	Size const seqpos
);


void
remove_variant_type_from_conformation_residue(
	conformation::Conformation & conformation,
	VariantType const & variant_type,
	Size const seqpos
);


void
add_lower_terminus_type_to_conformation_residue(
	conformation::Conformation & conformation,
	Size const seqpos
);


void
add_upper_terminus_type_to_conformation_residue(
	conformation::Conformation & conformation,
	Size const seqpos
);


void
remove_lower_terminus_type_from_conformation_residue(
	conformation::Conformation & conformation,
	Size const seqpos
);


void
remove_upper_terminus_type_from_conformation_residue(
	conformation::Conformation & conformation,
	Size const seqpos
);

/// @brief return of list of ResidueTypes corresponding to an annotated protein sequence
/// @param[in] sequence_in an annotated sequence
/// @param[in] residue_set the desired residue set
/// @param[in] auto_termini mark position 1, last_residue with lower, upper termini; default true
ResidueTypeCAPs residue_types_from_sequence(
	std::string const & sequence_in,
	chemical::ResidueTypeSet const & residue_set,
	bool const auto_termini = true
);


/// @brief create a Pose from an annotated protein sequence
/// @param[out] pose the new Pose, any existing data cleared
/// @param[in] sequence an annotated sequence
/// @param[in] residue_set the desired residue set
/// @param[in] auto_termini mark position 1, last_residue with lower, upper termini; default true
void make_pose_from_sequence(
	pose::Pose & pose,
	std::string const & sequence,
	chemical::ResidueTypeSet const & residue_set,
	bool const auto_termini = true
);

/// @brief create a Pose from an annotated protein sequence
/// @param[out] pose the new Pose, any existing data cleared
/// @param[in] sequence an annotated sequence
/// @param[in] string of the desired residue type set
/// @param[in] auto_termini mark position 1, last_residue with lower, upper termini; default true

void make_pose_from_sequence(
	pose::Pose & pose,
	std::string const & sequence,
	std::string const & type_set_name,
	//chemical::ResidueTypeSet const & residue_set,
	bool const auto_termini = true
);


/// @brief Returns the oneletter_sequence that corresponds to the given
/// annotated sequence.
std::string annotated_to_oneletter_sequence(
	std::string const & annotated_seq
);

/// @details the function allows a pose to use a different residue_type_set to
/// represent all its residues, such as from fullatom residues to centroid
/// residues, or vice versa. During the switch, corresponding atoms will be
/// copied. Redundant atoms will be removed (in case from fullatom to centroid)
/// and missing atoms will be built by ideal geometry (in the case from centroid
/// to fullatom).
void
switch_to_residue_type_set(
	pose::Pose & pose,
	std::string const & type_set_name
);

} // namespace chemical
} // namespace core

#endif
