// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @author Oliver Lange

#ifndef INCLUDED_core_coarse_Rules_FWD_HH
#define INCLUDED_core_coarse_Rules_FWD_HH



// Package headers
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/access_ptr.hh>
namespace core {
	namespace coarse {
	class Rule;
typedef utility::pointer::owning_ptr< Rule > RuleOP;
typedef utility::pointer::owning_ptr< Rule const > RuleCOP;
typedef utility::pointer::access_ptr< Rule > RuleAP;
typedef utility::pointer::access_ptr< Rule const > RuleCAP;

	class RuleSet;
	typedef utility::pointer::owning_ptr< RuleSet > RuleSetOP;
	typedef utility::pointer::owning_ptr< RuleSet const > RuleSetCOP;

	}
}

#endif
