// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Interface - information about the interface between to partners
/// @brief contains the following information:
///		calculate the interface between the two (or other?) partners
///		set the packer task to only pack the interface
/// @author Monica Berrondo


#ifndef INCLUDED_core_conformation_Interface_HH
#define INCLUDED_core_conformation_Interface_HH

// Unit headers
#include <core/conformation/Interface.fwd.hh>

// Package headers
#include <core/types.hh>
#include <core/conformation/Residue.fwd.hh> // replace with .fwd.hh
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// Symmetry headers
#include <core/conformation/symmetry/SymmetryInfo.fwd.hh>
#include <core/conformation/symmetry/SymmetricConformation.fwd.hh>

// Utility headers
#include <ObjexxFCL/FArray1D.hh>
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>

namespace core {
namespace conformation {

class
Interface : public utility::pointer::ReferenceCount {
public:

	typedef pack::task::PackerTaskOP PackerTaskOP;
	typedef core::Real Real;


	// default constructor
	Interface() {
		jump_number_ = 1;
		distance_ = 8.0;
	}

	// constructor with arguments
	Interface(
		Size const jump_number_in
	) : jump_number_( jump_number_in )
	{
		// set the default distance to 8 Angstrom (for cendist)
		// is this the correct number for a default?
		distance_ = 8.0;
	}

	void jump( Size const jump_number);
	void calculate( pose::Pose const & pose );
	void print( pose::Pose const & pose );
	void set_pack( pose::Pose const & pose, PackerTaskOP task );

	void distance( Real const distance_in );

	Vector center( pose::Pose const & pose );

	bool is_interface( conformation::Residue const & rsd ) const;// { return is_interface_( rsd.seqpos() ); }

	bool is_interface( Size const position ) const;// { return is_interface_(position); }

	/// this has to be the slowest possible way to do this, there has to be something better
	/// TODO fix
	bool is_pair(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2
	);
	// symmetric interfaces
	void set_symmetric_pack( pose::Pose const & pose, PackerTaskOP task );

	/// @brief Get two lists containing the residues on each side of the interface
	///
	/// You might expect something called pair_list() to output pairs or somehow
	/// relate to the is_pair function, but it does not.
	/// It returns a two element list.
	///  - The first element is a list of all residues on the lower partner of the
	///    interface.
	///  - The second element is a list of all the residues in the interface on the
	///    upper partner.
	/// Both lists are sorted by residue number, so the indices of one list have
	/// no relationship to the other list.
	/// @todo rename this to something more logical & give it a better return type
	/// @todo make a function that returns a vector1<pair<Size,Size> > containing
	/// all interacting pairs. This would be easy to implement.
	utility::vector1 < utility::vector1_int > pair_list() { return pair_list_; }

private:
	Size jump_number_;
	Real distance_;
	ObjexxFCL::FArray1D_bool partner_;
	ObjexxFCL::FArray1D_bool is_interface_;
	utility::vector1 < utility::vector1_int > pair_list_;
	//std::vector < bool > is_interface_;

	void protein_calculate( pose::Pose const & pose );
	void ligand_calculate( pose::Pose const & pose );
	void NA_calculate( pose::Pose const & ); //currently set to protein_calculate()
	void symmetric_protein_calculate( pose::Pose const & pose );
};

} // namespace conformation
} // namespace core

#endif
