// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragments/FragID.hh
/// @brief  set of fragments for a certain alignment frame
/// @author Oliver Lange (olange@u.washington.edu)
/// @author James Thompson
/// @date   Wed Oct 20 12:08:31 2007
///
#ifndef core_fragments_FragID_HH
#define core_fragments_FragID_HH

// Unit Headers
// #include <core/fragment/FragID.fwd.hh>

// Package Headers
#include <core/fragment/Frame.hh>
#include <core/fragment/FragData.fwd.hh>

// a very lightweight class ( only two memory cells )
// copy by value, don't use OPs

// FragID identifies a physical fragment by its Frame and intra_frame reference number.

namespace core {
namespace fragment {

class FragID : public std::pair < FrameOP, Size > {
public:
	FragID () {};
	FragID( FrameOP frame, Size frag_id ) : std::pair< FrameOP, Size> ( frame, frag_id ) {
		assert( frame->nr_frags() >= frag_id );
	};
	FrameCOP frame_ptr() const { return first; };
	Frame const& frame() const { return *first; };
	Frame& frame() { return *first; };
	Size id() const { return second; }; // stores the nr you get by asking frame.frag_id ( nr );
	FragData& fragment() { return frame().fragment( id() ); };
	FragDataCOP fragment_ptr() const { return frame().fragment_ptr( id() ); };
	Size apply( kinematics::MoveMap const& mm, pose::Pose& pose) const
	{
		return frame().apply( mm, id(), pose );
	};
	Size apply( pose::Pose& pose) const
	{
		return frame().apply( id(), pose );
	};
	// if we enable id != nr frame will need a map that can do frag_id --> nr
	bool is_valid() { return frame_ptr() && ( id() > 0 ) && fragment().is_valid(); };
	Size apply_ss( kinematics::MoveMap const& mm, std::string& ss ) const {
		return frame().apply_ss( mm, id(), ss );
	};
};

typedef utility::vector1< FragID > FragID_List;

} //fragment
} //core

#endif
