// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragments/FragSet.cc
/// @brief  set of fragments for a certain alignment frame
/// @author Oliver Lange (olange@u.washington.edu)
/// @author James Thompson (tex@u.washington.edu)
/// @date   Wed Oct 20 12:08:31 2007
///

// Unit Headers
#include <core/fragment/FragSetCollection.hh>

// Package Headers
#include <core/fragment/FragSet.hh>

// Project Headers
#include <core/types.hh>


// ObjexxFCL Headers

// Utility headers
#include <utility/vector1.fwd.hh>
//#include <utility/io/izstream.hh>
//#include <utility/pointer/owning_ptr.hh>

//#include <core/util/Tracer.hh>

#include <ostream>
#include <set>

namespace core {
namespace fragment {

//static util::Tracer tr("core.fragment");
using namespace kinematics;


Size FragSetCollection::region( MoveMap const& move_map, Size start, Size end, Size min_overlap, Size min_length, FrameList &frames ) const {
  Size count ( 0 );
  for ( FragSetList::const_iterator it = fragset_list_.begin(), eit = fragset_list_.end();
        it != eit; ++it ) {
    count += (*it)->region(  move_map, start, end, min_overlap, min_length, frames );
  };
  return count;
}

void FragSetCollection::add_fragset( FragSetOP fragset ) {
  if ( fragset->max_frag_length() > max_frag_length() ) set_max_frag_length( fragset->max_frag_length() );
  if ( fragset->min_pos() < min_pos() ) set_min_pos( fragset->min_pos() );
  if ( fragset->max_pos() > max_pos() ) set_max_pos( fragset->max_pos() );
  fragset_list_.push_back( fragset );
}


} //fragment
} //core
