// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragments/FragSet.hh
/// @brief  set of fragments
/// @author Oliver Lange ( olange@u.washington.edu)
/// @date   Wed Aug 22 12:08:31 2007
///

#ifndef core_fragments_FrameIterators_HH
#define core_fragments_FrameIterators_HH

// Unit Headers
#include <core/fragment/FragSet.fwd.hh>

// Package Headers
#include <core/fragment/FrameIteratorWorker_.hh>
#include <core/fragment/Frame.hh>
#include <core/fragment/FragID.hh>

// Project Headers
#include <core/kinematics/MoveMap.hh>
#include <core/types.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>

// std Headers
#include <iterator>

/*
Might change the FrameIterator to return FrameOP instead of Frame&...
This has the advantage of bein closer to the std:: implementations...
for instance one could do a
FrameList my_list;
FrameIterator it=fragset.begin(), eit=fragset.end();
copy( it, eit,back_inserter( my_list ));

the it-> wouldn't change, it still returns a Frame*
the *it would change and return a Frame* ...

*/

namespace core {
namespace fragment {


class FrameIterator : public std::iterator< std::forward_iterator_tag, Frame > {
	friend class BaseFragSet;
	friend class FragID_Iterator;

public:
	FrameIterator( FrameIteratorWorker_OP it ) : it_( it ) {};
	FrameIterator() : it_( NULL ) {};


	bool operator != ( FrameIterator const& fi) const {
		return (*it_)!=(*fi.it_);
	}

	bool operator == ( FrameIterator const& fi) const {
		return (*it_)==(*fi.it_);
	}

	FrameIterator& operator++ () {
		++(*it_);
		return *this;
	}

	FrameIterator& operator+ ( Size offset ) {
		(*it_)+( offset);
		return *this;
	}

	FrameIterator& operator = ( FrameIterator const& itr ) {
		it_=itr.it_; //copy the pointers to the real iterators
		return *this;
	}

	Frame* operator* () {
		return frame_ptr();
	}

	Frame const* operator* () const {
		return frame_ptr();
	}

	Frame* operator-> () {
		return frame_ptr();
	}

	Frame const* operator-> () const {
		return frame_ptr();
	}

	Frame* frame_ptr() {
		return it_->frame_ptr();
	}

	Frame const* frame_ptr() const{
		return it_->frame_ptr();
	}


protected:
	FrameIteratorWorker_OP it_;
};

}
}

#endif
