// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


/// @brief  some utilities for fragments
/// @author Oliver Lange (olange@u.washington.edu)
/// @date   Wed Oct 20 12:08:31 2007
///


#ifndef core_fragment_util_HH
#define core_fragment_util_HH

// Unit Headers

// Package Headers
#include <core/fragment/ConstantLengthFragSet.hh>
#include <core/fragment/JumpingFrame.hh>

// Project Headers
#include <core/types.hh>
#include <core/kinematics/FoldTree.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

// Utility headers
#include <utility/vector1.fwd.hh>

namespace core {
namespace fragment {

void steal_constant_length_frag_set_from_pose (
	core::pose::Pose const & pose, core::fragment::ConstantLengthFragSet & fragset
);

void steal_frag_set_from_pose(
	pose::Pose const & pose_in,
	FragSet & fragset,
	core::fragment::FragDataOP frag_type
);

/// @brief Function for chopping the X-sized fragments in source into fragments that
/// go into N-sized fragments in dest. Sizes are encoded by the value of
/// max_frag_length() in both source and dest.
void chop_fragments(
	core::fragment::FragSet & source, core::fragment::FragSet & dest
);


///@brief get frags that are fully within the Loop --- shorten(=true/false) frags that are close to the end of loops.
// can't live here because of dependency on protocols::loops --- look in protocol::loops::util for this method !
/*extern void select_loop_frags(
				 loops::Loops const& loops,
				 core::fragment::FragSet& source,
				 core::fragment::FragSet& loop_frags,
				 bool shorten = true
				 );*/


// undocumented function which passes variables around by reference for no obviou
// reason. Awesome.
void compute_per_residue_coverage(
	core::fragment::FragSet const & frags,
	utility::vector1< core::Size > & nr_frags
);

// create new FragSet ( same type as good_frags ) and fill up with frags from
// filling such that at each residue mn_nr_frags are available bRandom =>
// select fill fragments randomly
FragSetOP merge_frags( FragSet const& good_frags, FragSet const& filling, core::Size min_nr_frags, bool bRandom = true );

void flatten_list( FrameList const& frames, FragID_List& frag_ids );


/// @brief goes through all frag_data in the frame and puts the
/// best scoring one into the pose, i.e. quenches the frame
void
apply_best_scoring_fragdata(
	pose::Pose & pose,
	Frame const & frame,
	scoring::ScoreFunction const & sfxn
);

/// @brief writes FragData in multimodel pdb format
/// start_tag can be used to only write a subset
/// of the contained frag data
void dump_frames_as_pdb(
	pose::Pose const & pose,
	utility::vector1< FrameOP > const & frames,
	std::string const filename,
	core::Size start_frag = 1
);

/// @brief filling a frameset from a multimodel pdb file
/// @brief returns true if no error occured
bool fill_template_frames_from_pdb(
	pose::Pose const & pose,
	utility::vector1< FrameOP > const & template_frames,
	std::string const filename
);

void read_std_frags_from_cmd( FragSetOP& fragset_large, FragSetOP& fragset_small );

/// @brief given a JumpFrame with Up and DownJumpSRFDs as LAST SRFDs this will make a fold-tree compatible with the
/// Frame...   this is NOT GOOD for sampling, since it introduces cut-points outside of fragments
/// later for sampling: one could probably write a routine that looks if it can move existing Jumps in Fold-tree to
/// fit the FRAME ... if not it returns failure...
void make_simple_fold_tree_from_jump_frame( Frame const&, core::Size total_residue, kinematics::FoldTree& new_fold_tree );



} //fragment
} //core

#endif
