// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/graph/PointGraph.fwd.hh
/// @brief  Graph for detecting neighbors; vertices store points, edges store square distances
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#ifndef INCLUDED_core_graph_PointGraph_HH
#define INCLUDED_core_graph_PointGraph_HH

// Unit Headers
#include <core/graph/PointGraph.fwd.hh>

// Package Headers
#include <core/graph/PointGraphData.hh>
#include <core/graph/UpperEdgeGraph.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>

namespace core {
namespace graph {

void
residue_point_graph_from_pose(
	pose::Pose const & pose,
	PointGraph & pg
);

Distance
pose_max_nbr_radius( pose::Pose const & pose );

} // namespace graph
} // namespace core

#endif
