// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/grid/CartGrid.fwd.hh
///
/// @brief
/// @author Ian W. Davis


#ifndef INCLUDED_core_grid_CartGrid_FWD_HH
#define INCLUDED_core_grid_CartGrid_FWD_HH

#include <utility/pointer/owning_ptr.hh>

namespace core {
namespace grid {


class CartGrid; // fwd declaration
typedef utility::pointer::owning_ptr< CartGrid > CartGridOP;
typedef utility::pointer::owning_ptr< CartGrid const > CartGridCOP;


} // namespace grid
} // namespace core

#endif // INCLUDED_core_grid_CartGrid_FWD_HH
