// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/id/DOF_ID_Map.Pose.hh
/// @brief  DOF_ID_Map--Pose interaction functions
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_id_DOF_ID_Map_Pose_HH
#define INCLUDED_core_id_DOF_ID_Map_Pose_HH


// Package headers
#include <core/id/DOF_ID_Map.hh>

// Project headers
#include <core/conformation/Residue.hh>
#include <core/pose/Pose.hh>

// Utility headers
#include <utility/pointer/owning_ptr.hh>


namespace core {
namespace id {


/// @brief Initialize a DOF_ID_Map for a given Pose using the DOF_ID_Map's current default fill values
template< typename T >
void
initialize( DOF_ID_Map< T > & dof_map, pose::Pose const & pose )
{
	Size const n_res( pose.n_residue() );
	dof_map.clear();
	dof_map.resize( n_res );
	for ( Size i = 1; i <= n_res; ++i ) {
		dof_map.resize( i, pose.residue(i).natoms() );
	}
}


/// @brief Initialize a DOF_ID_Map for a given Pose using a specified fill value
template< typename T >
void
initialize( DOF_ID_Map< T > & dof_map, pose::Pose const & pose, T const & value )
{
	Size const n_res( pose.n_residue() );
	dof_map.clear();
	dof_map.resize( n_res );
	for ( Size i = 1; i <= n_res; ++i ) {
		dof_map.resize( i, pose.residue(i).natoms(), value );
	}
}


} // namespace id
} // namespace core


#endif // INCLUDED_core_id_DOF_ID_Map_Pose_HH
