// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/core/pose_stream/util.hh
/// @brief
/// @author James Thompson

#ifndef INCLUDED_core_pose_stream_util_HH
#define INCLUDED_core_pose_stream_util_HH


#include <core/io/pose_stream/PDBPoseInputStream.hh>
#include <core/io/pose_stream/PDBPoseInputStream.fwd.hh>
#include <core/io/pose_stream/MetaPoseInputStream.hh>
#include <core/io/pose_stream/ExtendedPoseInputStream.hh>
#include <core/io/pose_stream/SilentFilePoseInputStream.hh>
#include <core/io/pose_stream/SilentFilePoseInputStream.fwd.hh>

#include <core/sequence/util.hh>

#include <core/options/option.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>

#include <string>

namespace core {
namespace io {
namespace pose_stream {

core::io::pose_stream::MetaPoseInputStream streams_from_cmd_line() {
	using namespace core::options;
	using namespace core::options::OptionKeys;

	MetaPoseInputStream input;
	if ( option[ in::file::s ].user() ) {
		PDBPoseInputStreamOP pdb_input(
			new PDBPoseInputStream( option[ in::file::s ]() )
		);
		input.add_pose_input_stream( pdb_input );
	}
	if ( option[ in::file::l ].user() ) {
		PDBPoseInputStreamOP pdb_list_input(
			new PDBPoseInputStream
		);
		pdb_list_input->add_list_filenames( option[ in::file::l ]() );
		input.add_pose_input_stream( pdb_list_input );
	}

	if ( option[ in::file::silent ].user() ) {
		SilentFilePoseInputStreamOP silent_input;
		if ( option[ in::file::tags ].user() ) {
			silent_input =
				new SilentFilePoseInputStream(
					option[ in::file::silent ](),
					option[ in::file::tags ](),
					option[ in::file::silent_energy_cut ]()
				);
		} else {
			silent_input = new SilentFilePoseInputStream(
				option[ in::file::silent ](), option[ in::file::silent_energy_cut ]()
			);
		}

		silent_input->renumber_decoys( option[ in::file::silent_renumber ]() );

		input.add_pose_input_stream( silent_input );
	}

	if ( option[ in::file::extended_pose ].user() ) {
		Size const ntimes = option[ in::file::extended_pose ]();

		using utility::vector1;
		using utility::file::FileName;

		vector1< FileName > fasta_files( option[ in::file::fasta ]() );
		for ( vector1< FileName >::const_iterator it = fasta_files.begin(),
					end = fasta_files.end(); it != end; ++it
		) {

			std::string sequence
				= core::sequence::read_fasta_file( option[ in::file::fasta ]()[1] )[1]->sequence();

			PoseInputStreamOP extended_protein_input(
				new ExtendedPoseInputStream( sequence, ntimes )
			);
			input.add_pose_input_stream( extended_protein_input );
		}
	}

	return input;
} // streams_from_cmd_line

} // pose_stream
} // io
} // core

#endif
