// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file core/io/raw_data/ScoreStruct.hh
///
/// @brief Write out only the scores (equivalent to a scorefile)
/// @author James Thompson, Monica Berrondo

#ifndef INCLUDED_core_io_raw_data_ScoreStruct_HH
#define INCLUDED_core_io_raw_data_ScoreStruct_HH

// mini headers
#include <core/types.hh>
#include <core/pose/Pose.hh>

#include <core/io/raw_data/RawStruct.hh>

// C++ Headers

namespace core {
namespace io {
namespace raw_data {

	/////////////////////////////////////////////////////////////////////////////
	// holds all the data for a single entry in a silent file
	class ScoreStruct : public RawStruct {

	public:
		// constructor
		ScoreStruct() {
			decoy_tag_   = "empty";
		}

		ScoreStruct(
			core::pose::Pose, // pose,
			std::string tag = "empty_tag"
		) {
			// tag information
			decoy_tag_ = tag;
		}

		// destructor
		~ScoreStruct() {}

		ScoreStruct & operator= (
			ScoreStruct const & src
		);


		/// @brief Fill a Pose with the conformation information in this RawStruct and the FA_STANDARD
		/// ResidueTypeSet. This is a virtual method which must be implemented by classes derived from RawStruct.
		void fill_pose(
			core::pose::Pose & //pose
		);

		/// @brief Fill a Pose with the conformation information in this RawStruct and the ResidueTypeSet
		/// provided by the caller. This is a virtual method which must be implemented by classes derived from RawStruct.
		virtual void fill_pose(
			core::pose::Pose &, //pose,
			core::chemical::ResidueTypeSet const& residue_set
		);

		virtual Real get_debug_rmsd();
		virtual void print_conformation( std::ostream& out ) const;

}; // class ScoreStruct

} // namespace silent
} // namespace io
} // namespace core

#endif
