// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file core/io/silent/SilentStructFactory.cc
///
/// @brief silent input file reader for mini.
/// @author James Thompson

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <utility>
#include <vector>
#include <list>
#include <string>
#include <map>
#include <sstream>

// mini headers
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/char.functions.hh>
#include <ObjexxFCL/string.functions.hh>

#include <core/io/silent/silent.fwd.hh>
#include <core/io/silent/SilentStructFactory.hh>
#include <core/io/silent/ProteinSilentStruct.hh>
#include <core/io/silent/BinaryProteinSilentStruct.hh>
#include <core/io/silent/BinaryRNASilentStruct.hh>
#include <core/io/silent/RNA_SilentStruct.hh>
#include <core/io/silent/PDBSilentStruct.hh>
#include <core/io/silent/ScoreFileSilentStruct.hh>

#include <core/options/option.hh>

#include <core/util/Tracer.hh>


// option key includes

#include <core/options/keys/out.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>



namespace core {
namespace io {
namespace silent {

static core::util::Tracer tr("core.io.silent");

SilentStructFactory::SilentStructFactory() {}

SilentStructOP SilentStructFactory::get_silent_struct_in() {
	using namespace core::options;
	using namespace core::options::OptionKeys;

	return get_silent_struct( option[ in::file::silent_struct_type ]() );
}

SilentStructOP SilentStructFactory::get_silent_struct_out() {
	using namespace core::options;
	using namespace core::options::OptionKeys;
	return get_silent_struct( option[ out::file::silent_struct_type ]() );
}

SilentStructOP SilentStructFactory::get_silent_struct( std::string const & name ) {

	SilentStructOP new_ss_op;
	tr.Trace << "generate silent struct of type " << name << std::endl;
	if ( name == "rna" ) {
		new_ss_op = new RNA_SilentStruct;
	} else if  ( name == "binary_rna" ) {
		new_ss_op = new BinaryRNASilentStruct;
	} else if ( name == "binary" ) {
		new_ss_op = new BinaryProteinSilentStruct;
	} else if ( name == "protein" ) {
		new_ss_op = new ProteinSilentStruct;
	} else if ( name == "pdb" ) {
		new_ss_op = new PDBSilentStruct;
	} else if ( name == "score" ) {
		new_ss_op = new ScoreFileSilentStruct;
	} else {
		utility_exit_with_message( "Error: don't recognize silent-struct " + name + "!\n" );
	}
	return new_ss_op;
}

} // namespace silent
} // namespace io
} // namespace core
