// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/optimization/Multifunc.hh
/// @brief  Multifunction interface class
/// @author Phil Bradley


#ifndef INCLUDED_core_optimization_Multifunc_HH
#define INCLUDED_core_optimization_Multifunc_HH

// Unit headers
#include <core/optimization/Multifunc.fwd.hh>

// Package headers
#include <core/optimization/types.hh>

// Utility headers
#include <utility/pointer/ReferenceCount.hh>

namespace core {
namespace optimization {


/// @brief Multifunction interface class
class Multifunc : public utility::pointer::ReferenceCount
{
public:
	typedef utility::pointer::ReferenceCount parent;

protected: // Creation


	/// @brief Default constructor
	inline
	Multifunc() : parent()
	{}


	/// @brief Copy constructor
	inline
	Multifunc( Multifunc const & ) : parent()
	{}


public: // Creation


	/// @brief Destructor
	virtual
	~Multifunc()
	{}


protected: // Assignment


	/// @brief Copy assignment -- This code appears to NOT assign.  What is the purpose?
	inline
	Multifunc &
	operator =( Multifunc const & )
	{
		return *this;
	}


public:


	virtual
	Real
	operator ()( Multivec const & phipsi ) const = 0;


	virtual
	void
	dfunc( Multivec const & phipsi, Multivec & dE_dphipsi ) const = 0;

	/// @brief Error state reached; dump out something corresponding to the
	/// var assignment.  Default base class implementation: no_op();
	virtual
	void
	dump( Multivec const & /*vars*/ ) const
	{}

	// void
	// numerical_derivative_check(
	// 	// MinimizerMap const & min_map,
	// 	Multifunc const & func,
	// 	Multivec const & start_vars,
	// 	Multivec const & dE_dvars,
	// 	bool const verbose // = true
	// )
	// {
	// 	/////////////////////////////////////////////////////////////////////////////
	// 	// NUMERICAL DERIVATIVE CHECK
	// 	/////////////////////////////////////////////////////////////////////////////
	// 	// how to analyze this:
	// 	//
	// 	// in gnuplot, look at numerical vs analytical derivs:
	// 	// plot '< grep "^ratio" a3.log ' u 10:11,x
	// 	//
	// 	// also sort by deriv_dev lines:
	// 	//
	// 	// by magnitude of deviation
	// 	// grep deriv_dev a3.log | sort -g +8
	// 	//
	// 	// or by ratio of deviation to actual
	// 	//
	// 	// grep deriv_dev a3.log | sort -g +9
	//
	// 	Size const nangles( min_map.nangles() );
	//
	//
	// 	Real const increment = 0.0005; // PB -- 3/02
	// 	Size const n_increment = 5;
	// 	utility::vector1< Multivec > dE_dvars_numeric( n_increment );
	// 	for ( Size i=1; i<= n_increment; ++i ) {
	// 		dE_dvars_numeric[i].resize( nangles, 0.0 );
	// 	}
	// 	//FArray2D_Real dE_dvars_numeric( nangles, n_increment );
	//
	// 	// setup for saving diagnostics
	// 	MinDebug min_debug( nangles );
	//
	// // 	min_debug.nangles = nangles;
	// // 	if ( nangles > int( min_debug.abs_deriv_dev.size1() ) ) {
	// // 		min_debug.abs_deriv_dev.dimension( nangles );
	// // 		min_debug.rel_deriv_dev.dimension( nangles );
	// // 	}
	//
	// 	Multivec vars( start_vars );
	//
	// 	Real const f00 = func( vars );
	// 	Size ii( 1 ); // for indexing into dE_dvars[ ii ]
	//
	// 	for ( MinimizerMap::const_iterator iter= min_map.begin(),
	// 					iter_end = min_map.end(); iter != iter_end; ++iter, ++ii ) {
	// 		DOF_Node const & dof_node( **iter );
	//
	// 		Real deriv_dev = 10000.0;
	// 		for ( Size j = 1,factor=1; j <= n_increment; ++j ) {
	// 			factor*=2;
	//
	// 			vars[ii] = start_vars[ii] + factor * increment;
	// 			Real const f11 = func( vars );
	//
	// 			vars[ii] = start_vars[ii] - factor * increment;
	// 			Real const f22 = func( vars );
	//
	// 			Real const deriv = ( f11 - f22 ) / ( factor * 2 * increment );
	//
	// 			dE_dvars_numeric[j][ii] = deriv;
	//
	// 			deriv_dev = std::min( deriv_dev, std::abs( deriv  - dE_dvars[ii] ) );
	//
	// 			vars[ii] = start_vars[ii];
	//
	// 			Real const ratio( std::abs( dE_dvars[ii] ) < 0.001 ? 0.0 :
	// 												 deriv / dE_dvars[ii] );
	//
	// 			if ( verbose &&
	// 					 ( std::abs(dE_dvars[ii]) > 0.001 || std::abs(deriv) > 0.001 ) ) {
	// 				// if you change this output, please also change the comments
	// 				// at the beginning of this section
	// 				static bool ratio_header_output( false );
	// 				if ( !ratio_header_output ) {
	// 					ratio_header_output = true;
	// 					std::cout << "ratio" <<
	// 						A( 4, "inc" ) <<
	// 						A( 4, "rsd" ) <<
	// 						A( 4, "typ" ) <<
	// 						A( 4, "atm" ) <<
	// 						A( 5, "prsd" ) <<
	// 						A( 5, "ptyp" ) <<
	// 						A( 5, "patm" ) <<
	// 						A( 5, "natm" ) <<
	// 						A( 10, "numeric" ) <<
	// 						A( 10, "analytic" ) <<
	// 						A( 10, "ratio" ) <<
	// 						A( 10, "f11" ) <<
	// 						A( 10, "f00" ) <<
	// 						A( 10, "f22" ) <<
	// 						A( 10, "vars[ii]" ) << std::endl;
	// 				}
	//
	// 				id::DOF_ID parent_id( id::BOGUS_DOF_ID );
	// 				if ( dof_node.parent() ) {
	// 					parent_id = dof_node.parent()->dof_id();
	// 				}
	//
	// 				std::cout << "ratio" <<
	// 					I( 4, j ) <<
	// 					I( 4, dof_node.rsd() ) <<
	// 					I( 4, dof_node.type() ) <<
	// 					I( 4, dof_node.atomno() ) <<
	// 					I( 5, parent_id.rsd() ) <<
	// 					I( 5, parent_id.type() ) <<
	// 					I( 5, parent_id.atomno() ) <<
	// 					I( 5, dof_node.atoms().size()) <<
	// 					F( 10, 4, deriv ) <<
	// 					F( 10, 4, dE_dvars[ii] ) <<
	// 					F( 10, 4, ratio ) <<
	// 					F( 10, 4, f11 ) <<
	// 					F( 10, 4, f00 ) <<
	// 					F( 10, 4, f22 ) <<
	// 					F( 10, 4, start_vars[ii] ) << std::endl;
	// 			}
	// 		}
	// 		if ( true ) {
	//
	// 			Real const ratio( std::abs( dE_dvars[ii] ) < 0.001 ? 0.0 :
	// 												 deriv_dev / std::abs( dE_dvars[ii] ) );
	//
	// 			min_debug.rel_deriv_dev[ ii ] = ratio;
	// 			min_debug.abs_deriv_dev[ ii ] = deriv_dev;
	//
	// 			if ( verbose ) {
	// 				// if you change this output, please also change the comments
	// 				// at the beginning of this section
	// 				std::cout << "deriv_dev:" << SS(ii) << SS(nangles) << SS(f00) <<
	// 					SS( dof_node.type() ) << SS( dof_node.atomno() ) <<
	// 					SS( dof_node.rsd() ) <<
	// 					SS( dE_dvars[ii] ) << SS( deriv_dev ) << SS(ratio) << std::endl;
	// 			}
	// 		}
	// 	}
	//
	// 	// calculate magnitudes, dot products of gradient vectors
	// 	utility::vector1< Real > norm_numeric(n_increment,0.0), dot(n_increment,0.0);
	// 	Real norm(0.0);
	// 	for ( Size i=1; i<= nangles; ++i ) {
	// 		norm += dE_dvars[i] * dE_dvars[i];
	// 		for ( Size j=1; j<= n_increment; ++j ) {
	// 			dot[j] += dE_dvars[i] * dE_dvars_numeric[j][i];
	// 			norm_numeric[j] += dE_dvars_numeric[j][i] * dE_dvars_numeric[j][i];
	// 		}
	// 	}
	// 	norm = std::sqrt( norm );
	//
	// 	min_debug.best_cos_theta = -10.0;
	// 	min_debug.best_abs_log_norm_ratio = 200.0;
	// 	min_debug.best_norm_analytic = 999.9;
	// 	min_debug.best_norm_numeric  = 999.9;
	//
	// 	for ( Size j=1; j<= n_increment; ++j ) {
	// 		norm_numeric[j] = std::sqrt( norm_numeric[j] );
	//
	// 		// handle strange cases
	// 		Real log_norm_ratio;
	// 		if ( norm < 0.001 && norm_numeric[j] < 0.001 ) {
	// 			log_norm_ratio = 1.0;
	// 		} else if ( norm < 0.001 ) {
	// 			log_norm_ratio = 100.0;
	// 		} else if ( norm_numeric[j] < 0.001 ) {
	// 			log_norm_ratio = -100.0;
	// 		} else {
	// 			log_norm_ratio = std::log( norm_numeric[j] / norm );
	// 		}
	//
	// 		Real const cos_theta( dot[j] / ( norm * norm_numeric[j]) );
	//
	// 		std::cout <<
	// 			" norm: " << j << ' ' << norm <<
	// 			" norm_numeric: " << norm_numeric[j] <<
	// 			" cos_theta: " << cos_theta <<
	// 			" log_norm_ratio: " << log_norm_ratio << std::endl;
	//
	// 		min_debug.best_cos_theta = std::max( min_debug.best_cos_theta,
	// 																					cos_theta );
	// 		if ( std::abs( log_norm_ratio ) < min_debug.best_abs_log_norm_ratio ) {
	// 			min_debug.best_abs_log_norm_ratio = std::abs( log_norm_ratio );
	// 			min_debug.best_norm_analytic = norm;
	// 			min_debug.best_norm_numeric = norm_numeric[j];
	// 		}
	// 	}

}; // Multifunc


} // namespace optimization
} // namespace core


#endif // INCLUDED_core_optimization_Multifunc_HH
