// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/OptionKeys.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_options_keys_OptionKeys_HH
#define INCLUDED_core_options_keys_OptionKeys_HH


// Utility headers
#include <utility/options/keys/all.hh>


namespace core {
namespace options {


typedef  utility::options::OptionKey  OptionKey;
typedef  utility::options::BooleanOptionKey  BooleanOptionKey;
typedef  utility::options::IntegerOptionKey  IntegerOptionKey;
typedef  utility::options::RealOptionKey  RealOptionKey;
typedef  utility::options::StringOptionKey  StringOptionKey;
typedef  utility::options::FileOptionKey  FileOptionKey;
typedef  utility::options::PathOptionKey  PathOptionKey;
typedef  utility::options::BooleanVectorOptionKey  BooleanVectorOptionKey;
typedef  utility::options::IntegerVectorOptionKey  IntegerVectorOptionKey;
typedef  utility::options::RealVectorOptionKey  RealVectorOptionKey;
typedef  utility::options::StringVectorOptionKey  StringVectorOptionKey;
typedef  utility::options::FileVectorOptionKey  FileVectorOptionKey;
typedef  utility::options::PathVectorOptionKey  PathVectorOptionKey;


namespace OptionKeys {


// Include options generated by Python script
//#include <core/options/keys/OptionKeys.hh.gen.hh>


/// @brief Lookup functors
typedef  OptionKey  KeyType;
#include <utility/keys/KeyLookup.functors.hh>


} // namespace OptionKeys
} // namespace options
} // namespace core


#endif // INCLUDED_core_options_keys_OptionKeys_HH
