// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/cluster.OptionKeys.gen.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author James M. Thompson (tex@u.washington.edu)

#ifndef INCLUDED_core_options_keys_cluster_OptionKeys_gen_HH
#define INCLUDED_core_options_keys_cluster_OptionKeys_gen_HH

// Unit headers
#include <core/options/keys/OptionKeys.hh>

namespace core {
namespace options {
namespace OptionKeys {

namespace cluster { extern BooleanOptionKey const cluster; }
namespace cluster { extern RealOptionKey const input_score_filter; }
namespace cluster { extern RealOptionKey const output_score_filter; }
namespace cluster { extern IntegerVectorOptionKey const exclude_res; }
namespace cluster { extern RealOptionKey const thinout_factor; }
namespace cluster { extern RealOptionKey const radius; }
namespace cluster { extern IntegerOptionKey const limit_cluster_size; }
namespace cluster { extern IntegerOptionKey const limit_clusters; }
namespace cluster { extern IntegerOptionKey const limit_total_structures; }
namespace cluster { extern BooleanOptionKey const sort_groups_by_energy; }
namespace cluster { extern BooleanOptionKey const remove_singletons; }
namespace cluster { extern BooleanOptionKey const remove_highest_energy_member; }
namespace cluster { extern IntegerOptionKey const limit_dist_matrix; }
namespace cluster { extern BooleanOptionKey const make_ensemble_cst; }
namespace cluster { extern BooleanOptionKey const hotspot_hash; }
namespace cluster { extern BooleanOptionKey const loops; }

} // namespace OptionKeys
} // namespace options
} // namespace core

#endif
