// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/evaluation.OptionKeys.gen.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author James M. Thompson (tex@u.washington.edu)

#ifndef INCLUDED_core_options_keys_evaluation_OptionKeys_gen_HH
#define INCLUDED_core_options_keys_evaluation_OptionKeys_gen_HH

// Unit headers
#include <core/options/keys/OptionKeys.hh>

namespace core {
namespace options {
namespace OptionKeys {

namespace evaluation { extern BooleanOptionKey const evaluation; }
namespace evaluation { extern FileVectorOptionKey const rmsd_target; }
namespace evaluation { extern StringVectorOptionKey const rmsd_column; }
namespace evaluation { extern FileVectorOptionKey const rmsd_select; }
namespace evaluation { extern BooleanOptionKey const gdtmm; }
namespace evaluation { extern BooleanOptionKey const score_with_rmsd; }
namespace evaluation { extern FileVectorOptionKey const constraints; }
namespace evaluation { extern FileVectorOptionKey const constraints_column; }
namespace evaluation { extern FileOptionKey const chemical_shifts; }
namespace evaluation { extern FileVectorOptionKey const extra_score; }
namespace evaluation { extern FileVectorOptionKey const extra_score_patch; }
namespace evaluation { extern StringVectorOptionKey const extra_score_column; }
namespace evaluation { extern BooleanOptionKey const symmetric_rmsd; }
namespace evaluation { extern FileVectorOptionKey const rdc_select; }
namespace evaluation { extern FileVectorOptionKey const rdc_target; }
namespace evaluation { extern StringVectorOptionKey const rdc_column; }
namespace evaluation { extern BooleanOptionKey const jump_nr; }

} // namespace OptionKeys
} // namespace options
} // namespace core

#endif
