// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/frags.OptionKeys.gen.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author James M. Thompson (tex@u.washington.edu)

#ifndef INCLUDED_core_options_keys_frags_OptionKeys_gen_HH
#define INCLUDED_core_options_keys_frags_OptionKeys_gen_HH

// Unit headers
#include <core/options/keys/OptionKeys.hh>

namespace core {
namespace options {
namespace OptionKeys {

namespace frags { extern BooleanOptionKey const frags; }
namespace frags { extern IntegerOptionKey const n_frags; }
namespace frags { extern FileOptionKey const allowed_pdb; }
namespace frags { extern StringVectorOptionKey const ss_pred; }
namespace frags { extern FileOptionKey const denied_pdb; }
namespace frags { extern IntegerVectorOptionKey const frag_sizes; }
namespace frags { extern BooleanOptionKey const annotate; }
namespace frags { extern IntegerOptionKey const nr_large_copies; }
namespace frags { extern IntegerOptionKey const n_candidates; }
namespace frags { extern StringOptionKey const describe_fragments; }
namespace frags { namespace scoring { extern BooleanOptionKey const scoring; } }
namespace frags { namespace scoring { extern FileOptionKey const config; } }
namespace frags { namespace scoring { extern StringOptionKey const profile_score; } }
namespace frags { namespace scoring { extern FileVectorOptionKey const predicted_secondary; } }
namespace frags { namespace picking { extern BooleanOptionKey const picking; } }
namespace frags { namespace picking { extern StringOptionKey const selecting_rule; } }
namespace frags { namespace picking { extern RealVectorOptionKey const quota_fractions; } }

} // namespace OptionKeys
} // namespace options
} // namespace core

#endif
