// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/membrane.OptionKeys.gen.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author James M. Thompson (tex@u.washington.edu)

#ifndef INCLUDED_core_options_keys_membrane_OptionKeys_gen_HH
#define INCLUDED_core_options_keys_membrane_OptionKeys_gen_HH

// Unit headers
#include <core/options/keys/OptionKeys.hh>

namespace core {
namespace options {
namespace OptionKeys {

namespace membrane { extern BooleanOptionKey const membrane; }
namespace membrane { extern IntegerOptionKey const normal_cycles; }
namespace membrane { extern RealOptionKey const normal_mag; }
namespace membrane { extern RealOptionKey const center_mag; }
namespace membrane { extern RealOptionKey const smooth_move_frac; }
namespace membrane { extern BooleanOptionKey const no_interpolate_Mpair; }
namespace membrane { extern BooleanOptionKey const Menv_penalties; }
namespace membrane { extern RealOptionKey const tmp_real1; }
namespace membrane { extern RealOptionKey const tmp_real2; }
namespace membrane { extern RealOptionKey const tmp_real3; }
namespace membrane { extern IntegerOptionKey const tmp_int1; }
namespace membrane { extern IntegerOptionKey const tmp_int2; }
namespace membrane { extern IntegerOptionKey const tmp_int3; }
namespace membrane { extern BooleanOptionKey const tmp_bool1; }
namespace membrane { extern BooleanOptionKey const tmp_bool2; }
namespace membrane { extern BooleanOptionKey const tmp_bool3; }
namespace membrane { extern BooleanOptionKey const debug; }
namespace membrane { extern BooleanOptionKey const view; }

} // namespace OptionKeys
} // namespace options
} // namespace core

#endif
