// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/keys/score.OptionKeys.gen.hh
/// @brief  core::options::OptionKeys collection
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author James M. Thompson (tex@u.washington.edu)

#ifndef INCLUDED_core_options_keys_score_OptionKeys_gen_HH
#define INCLUDED_core_options_keys_score_OptionKeys_gen_HH

// Unit headers
#include <core/options/keys/OptionKeys.hh>

namespace core {
namespace options {
namespace OptionKeys {

namespace score { extern BooleanOptionKey const score; }
namespace score { extern StringOptionKey const weights; }
namespace score { extern StringOptionKey const patch; }
namespace score { extern BooleanOptionKey const dun08; }
namespace score { extern BooleanOptionKey const empty; }
namespace score { extern RealOptionKey const fa_max_dis; }
namespace score { extern BooleanOptionKey const fa_Hatr; }
namespace score { extern BooleanOptionKey const no_smooth_etables; }
namespace score { extern RealOptionKey const etable_lr; }
namespace score { extern StringOptionKey const input_etables; }
namespace score { extern StringOptionKey const output_etables; }
namespace score { extern RealOptionKey const rms_target; }
namespace score { extern BooleanOptionKey const ramaneighbors; }
namespace score { extern StringOptionKey const optH_weights; }
namespace score { extern StringOptionKey const optH_patch; }
namespace score { extern IntegerOptionKey const symE_units; }
namespace score { extern RealOptionKey const symE_bonus; }
namespace score { extern RealOptionKey const NV_lbound; }
namespace score { extern RealOptionKey const NV_ubound; }
namespace score { extern StringOptionKey const NV_table; }
namespace score { extern BooleanOptionKey const new_hb; }
namespace score { extern StringOptionKey const p_aa_pp; }
namespace score { extern StringOptionKey const ch_o_bond_potential; }
namespace score { extern BooleanOptionKey const yf_chbond; }
namespace score { extern BooleanOptionKey const disable_orientation_dependent_rna_ch_o_bonds; }
namespace score { extern BooleanOptionKey const rama_not_squared; }
namespace score { extern BooleanOptionKey const find_neighbors_3dgrid; }
namespace score { extern BooleanOptionKey const exact_occ_pairwise; }
namespace score { extern BooleanOptionKey const exact_occ_split_between_res; }
namespace score { extern StringVectorOptionKey const ref_offsets; }
namespace score { extern BooleanOptionKey const output_residue_energies; }
namespace score { extern StringOptionKey const fa_custom_pair_distance_file; }

} // namespace OptionKeys
} // namespace options
} // namespace core

#endif
