// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/option.cc
/// @brief  Program options global and initialization function
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Unit headers
#include <core/options/option.hh>
#include <core/options/option.cc.include.gen.hh>

// Utility headers
#include <utility/options/OptionCollection.hh>

// option key includes

#include <core/util/Tracer.hh>

#include <core/options/keys/out.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>
#include <core/options/keys/packing.OptionKeys.gen.hh>

#include <core/options/option.cc.gen.hh>
namespace core {
namespace options {


/// @details OptionCollection global
utility::options::OptionCollection option;


/// @brief Named verbosity levels
int const silent  ( 0 ); // No messages output
int const quiet   ( 1 );
int const standard( 2 );
int const inform  ( 4 );
int const chat    ( 6 );
int const yap     ( 7 );
int const gush    ( 8 );
int const verbose ( 9 ); // All messages output


/// @brief Initialize the options
OptionCollection &
initialize()
{

	using namespace utility::options;
	using namespace core::options::OptionKeys;
	using utility::file::PathName;
#ifdef BOINC
	std::cerr << "Options::initialize()" << std::endl; std::cerr.flush();
#endif
	// Load the built-in options
	option.add_built_in_options();
#ifdef BOINC
	std::cerr << "Options::adding_options()" << std::endl; std::cerr.flush();
#endif
	// Include options generated by Python script

	add_all_rosetta_options( option );
#ifdef BOINC
	std::cerr << "Options::initialize() Check specs." << std::endl; std::cerr.flush();
#endif
	// Check for problems in the option specifications
	option.check_specs();
#ifdef BOINC
	std::cerr << "Options::initialize()  End reached" << std::endl; std::cerr.flush();
#endif

	return option;
}


/// @brief Process the specified options
/// note Do more complex value setup and checks here than the option system provides
OptionCollection &
process()
{
	using namespace utility::options;

	core::util::Tracer tr("core.options");

	{ // Stupid binary fullatom options that really suck.
		using namespace core::options;
		using namespace core::options::OptionKeys;
		if ( option[ in::file::fullatom ].user() ) {
			tr.Warning << "option[ in::file::fullatom ]() re-interpreted as setting "
				<< "option[ in::file::residue_type_set ]() to ";
			std::string type_set_name("fa_standard");
			if ( !option[ in::file::fullatom ]() ) {
				type_set_name = "centroid";
			}

			tr.Warning << type_set_name << std::endl;
			option[ in::file::residue_type_set ].value( type_set_name );
		}

		if ( option[ out::file::fullatom ].user() ) {
			tr.Warning << "option[ out::file::fullatom ]() re-interpreted as setting "
				<< "option[ out::file::residue_type_set ]() to ";
			std::string type_set_name("fa_standard");
			if ( !option[ out::file::fullatom ]() ) {
				type_set_name = "centroid";
			}

			tr.Warning << type_set_name << std::endl;
			option[ out::file::residue_type_set ].value( type_set_name );
		}
	}

	{ // Input paths
		using namespace core::options::OptionKeys::in::path;

		option[ fragments ].default_to( option[ path ] );
		option[ pdb ].default_to( option[ path ] );
		option[ database ].default_to( option[ path ] );
	}

	{ // Output paths
		using namespace core::options::OptionKeys::out::path;

		option[ pdb ].default_to( option[ path ] );
		option[ score ].default_to( option[ path ] );
		option[ movie ].default_to( option[ path ] );
	}

	{ // Packing options
		using namespace core::options::OptionKeys::packing;

		if ( option[ solvate ] ) option[ explicit_h2o ].value( true ); // -solvate => -explicit_h2o
	}

	tr.flush();
	return option;
}


} // namespace options
} // namespace core
