// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/options/option.hh
/// @brief  Program options global and initialization function
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Utility headers
#include <utility/options/OptionCollection.hh>

// Package headers
//#include <core/options/keys/OptionKeys.hh> // Convenience


#ifndef INCLUDED_core_options_option_HH
#define INCLUDED_core_options_option_HH


namespace core {
namespace options {


// Types
typedef  utility::options::OptionCollection  OptionCollection;
typedef  utility::options::Option  Option;
typedef  utility::options::BooleanOption  BooleanOption;
typedef  utility::options::IntegerOption  IntegerOption;
typedef  utility::options::RealOption  RealOption;
typedef  utility::options::StringOption  StringOption;
typedef  utility::options::FileOption  FileOption;
typedef  utility::options::PathOption  PathOption;
typedef  utility::options::BooleanVectorOption  BooleanVectorOption;
typedef  utility::options::IntegerVectorOption  IntegerVectorOption;
typedef  utility::options::RealVectorOption  RealVectorOption;
typedef  utility::options::StringVectorOption  StringVectorOption;
typedef  utility::options::FileVectorOption  FileVectorOption;
typedef  utility::options::PathVectorOption  PathVectorOption;


/// @brief OptionCollection global
extern OptionCollection option;


/// @brief Named verbosity levels
extern int const silent  ; // No messages output
extern int const quiet   ;
extern int const standard;
extern int const inform  ;
extern int const chat    ;
extern int const yap     ;
extern int const gush    ;
extern int const verbose ; // All messages output


/// @brief Initialize the options
OptionCollection &
initialize();


/// @brief Process the specified options
OptionCollection &
process();


} // namespace options
} // namespace core


#endif // INCLUDED_core_options_option_HH
