// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange

#include <core/options/option.hh>
#include <core/options/keys/OptionKeys.hh>
#include <core/options/after_opts.hh>


#define OPT(akey)							\
  core::options::option.add_relevant( core::options::OptionKeys::akey )

#define NEW_OPT(akey,help,adef)						\
  core::options::option.add( core::options::OptionKeys::akey , help ).def( adef ); \
  OPT( akey )

#define OPT_KEY( type, key )					       \
  namespace core { 	namespace options {	namespace OptionKeys {	\
	core::options::type##OptionKey const key( #key );		\
      }}}

#define OPT_1GRP_KEY( type, grp, key )					\
  namespace core { 	namespace options {	namespace OptionKeys { namespace grp { \
	  core::options::type##OptionKey const key( #grp":"#key );	\
	}}}}


#define EXTERN_OPT_1GRP_KEY( type, grp, key )					\
  namespace core { 	namespace options {	namespace OptionKeys { namespace grp { \
			extern core::options::type##OptionKey const key;			\
	}}}}


#define OPT_2GRP_KEY( type, grp1, grp2, key )				\
  namespace core { 	namespace options {	namespace OptionKeys { namespace grp1 { namespace grp2 { \
	    core::options::type##OptionKey const key( #grp1":"#grp2":"#key ); \
	  }}}}}

#define OPT_3GRP_KEY( type, grp1, grp2, grp3, key )				\
  namespace core { 	namespace options {	namespace OptionKeys { namespace grp1 { namespace grp2 { namespace grp3 { \
	    core::options::type##OptionKey const key( #grp1":"#grp2":"#grp3":"#key ); \
	  }}}}}}
