// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/annealer/FixbbCoupledRotamerSimAnnealer.hh
/// @brief  Packer's standard annealer class declaration
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#ifndef INCLUDED_core_pack_annealer_FixbbCoupledRotamerSimAnnealer_HH
#define INCLUDED_core_pack_annealer_FixbbCoupledRotamerSimAnnealer_HH

// Unit Headers
#include <core/pack/annealer/FixbbCoupledRotamerSimAnnealer.fwd.hh>

// Package Headers
#include <core/pack/annealer/RotamerAssigningAnnealer.hh>

#include <core/pack/interaction_graph/InteractionGraphBase.fwd.hh>

#include <core/pack/rotamer_set/RotamerSets.fwd.hh>
#include <core/pack/rotamer_set/RotamerSet.fwd.hh>
#include <core/pack/rotamer_set/RotamerCouplings.fwd.hh>

namespace core {
namespace pack {
namespace annealer {

class FixbbCoupledRotamerSimAnnealer;

class FixbbCoupledRotamerSimAnnealer : public RotamerAssigningAnnealer
{
public:
	typedef interaction_graph::InteractionGraphBaseOP InteractionGraphBaseOP;
	typedef rotamer_set::RotamerSetsCOP RotamerSetsCOP;
	typedef rotamer_set::RotamerSetCOP RotamerSetCOP;
	typedef rotamer_set::RotamerCouplingsOP   RotamerCouplingsOP;
	typedef rotamer_set::RotamerCouplingsCOP  RotamerCouplingsCOP;

public:
	FixbbCoupledRotamerSimAnnealer(
		std::vector<int> & rot_to_pack,
		ObjexxFCL::FArray1D_int & bestrotamer_at_seqpos,
		PackerEnergy & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		InteractionGraphBaseOP ig,
		RotamerSetsCOP rotamer_sets,
		ObjexxFCL::FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		ObjexxFCL::FArray1D< PackerEnergy > & rot_freq,
		RotamerCouplingsCOP rotamer_couplings
	);

	FixbbCoupledRotamerSimAnnealer(
		ObjexxFCL::FArray1D_int & bestrotamer_at_seqpos,
		PackerEnergy & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		InteractionGraphBaseOP ig,
		RotamerSetsCOP rotamer_sets,
		ObjexxFCL::FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		ObjexxFCL::FArray1D< PackerEnergy > & rot_freq,
		RotamerCouplingsCOP rotamer_couplings
	);


	virtual ~FixbbCoupledRotamerSimAnnealer();

	/// @brief sim_annealing for fixed backbone design mode
	void run();

 private:
	void
	setup_rotamer_couplings( RotamerCouplingsCOP rotamer_couplings );

	InteractionGraphBaseOP ig_;
	FixbbCoupledRotamerSimAnnealer(const FixbbCoupledRotamerSimAnnealer& rhs);
	RotamerCouplingsOP rotamer_couplings_;
};

}//end namespace annealer
}//end namespace pack
}//end namespace core

#endif
