// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/rtmin.hh
/// @brief  rotamer trials with minimization module header
/// @author Ian W. Davis (ian.w.davis@gmail.com)
/// @author Ian W. Davis (ian.w.davis@gmail.com)

#ifndef INCLUDED_core_pack_rtmin_HH
#define INCLUDED_core_pack_rtmin_HH

// pack headers
#include <core/pack/task/PackerTask.fwd.hh>

// pose headers
#include <core/pose/Pose.fwd.hh>

// scoring headers
#include <core/scoring/ScoreFunction.fwd.hh>

// conformation headers
#include <core/chemical/ResidueTypeSet.fwd.hh>

namespace core {
namespace pack {

void
rtmin(
	pose::Pose & pose,
	scoring::ScoreFunction const & sfxn,
	task::PackerTaskCOP input_task
);

}
}

#endif
