// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/operation/ResFilterFactory.cc
/// @brief
/// @author ashworth

#include <core/pack/task/operation/ResFilterFactory.hh>

#include <core/pack/task/operation/ResFilters.hh>

#include <utility/exit.hh> // runtime_assert, utility_exit_with_message
#include <utility/Tag/Tag.hh>

namespace core {
namespace pack {
namespace task {
namespace operation {

ResFilterFactory::ResFilterFactory() : parent() {}
ResFilterFactory::~ResFilterFactory(){}

///@brief add a ResFilter prototype, using its default type name as the map key
void
ResFilterFactory::add_type( ResFilterOP filter, std::string type /* = std::string() */ )
{
	runtime_assert( filter );
	if ( type.empty() ) type = filter->type();
	if ( type == "UNIMPLEMENTED TYPE STRING" ) {
		utility_exit_with_message("Can't map derived ResFilter with unimplemented type() method.");
	}
	filter_map_[ type ] = filter;
}

bool ResFilterFactory::has_type( std::string const & type ) const
{
	return ( filter_map_.find( type ) != filter_map_.end() );
}

///@brief return new ResFilter by key lookup in filter_map_ (new ResFilter parses Tag if provided)
ResFilterOP
ResFilterFactory::newResFilter(
	std::string const & type,
	TagPtr tag /* = boost::shared_ptr< Tag >() */
) const
{
	ResFilterMap::const_iterator iter( filter_map_.find( type ) );
	if ( iter != filter_map_.end() ) {
		ResFilterOP filter( iter->second->clone() );
		// parse tag if tag pointer is pointing to one
		if ( tag.get() != NULL ) filter->parse_tag( tag );
		return filter;
	} else {
		utility_exit_with_message( type + " is not known to the ResFilterFactory. ResFilters outside of core::pack::task::operation must be registered via the add_type method from elsewhere in the code." );
		return NULL;
	}
}

} //namespace operation
} //namespace task
} //namespace pack
} //namespace core
