// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/operation/ResFilters.hh
/// @brief  core-level (very general) classes that take a pose and a residue index, and return true or false
/// @author ashworth

#ifndef INCLUDED_core_pack_task_operation_ResFilters_HH
#define INCLUDED_core_pack_task_operation_ResFilters_HH

// Unit Headers
#include <core/pack/task/operation/ResFilters.fwd.hh>

#include <core/pack/task/operation/ResFilter.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>

namespace core {
namespace pack {
namespace task {
namespace operation {

class ResidueHasProperty : public ResFilter {
public:
	typedef ResFilter parent;
public:
	ResidueHasProperty();
	ResidueHasProperty( std::string const & );
	virtual bool operator() ( Pose const &, Size ) const;
	virtual ResFilterOP clone() const;
	virtual std::string type() const { return "ResidueHasProperty"; }
	virtual void parse_tag( TagPtr );
private:
	std::string property_;
};

class ResidueLacksProperty : public ResFilter {
public:
	typedef ResFilter parent;
public:
	ResidueLacksProperty();
	ResidueLacksProperty( std::string const & );
	virtual bool operator() ( Pose const &, Size ) const;
	virtual ResFilterOP clone() const;
	virtual std::string type() const { return "ResidueLacksProperty"; }
	virtual void parse_tag( TagPtr );
private:
	std::string property_;
};

class ResidueName3Is : public ResFilter {
public:
	typedef ResFilter parent;
public:
	ResidueName3Is();
	ResidueName3Is( std::string const & );
	virtual bool operator() ( Pose const &, Size ) const;
	virtual ResFilterOP clone() const;
	virtual std::string type() const { return "ResidueName3Is"; }
	virtual void parse_tag( TagPtr );
private:
	std::string name3_;
};

} //namespace operation
} //namespace task
} //namespace pack
} //namespace core

#endif
