// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/operation/ResLvlTaskOperationFactory.cc
/// @brief
/// @author ashworth

#include <core/pack/task/operation/ResLvlTaskOperationFactory.hh>

#include <core/pack/task/operation/ResLvlTaskOperations.hh>

#include <utility/exit.hh> // runtime_assert, utility_exit_with_message
#include <utility/Tag/Tag.hh>

namespace core {
namespace pack {
namespace task {
namespace operation {

ResLvlTaskOperationFactory::ResLvlTaskOperationFactory()
	: parent()
{}

ResLvlTaskOperationFactory::~ResLvlTaskOperationFactory(){}

///@brief add a ResLvlTaskOperation prototype, using its default type name as the map key
void
ResLvlTaskOperationFactory::add_type(
	ResLvlTaskOperationOP rlto,
	std::string type /* = std::string() */
)
{
	runtime_assert( rlto );
	if ( type.empty() ) type = rlto->type();
	if ( type == "UNIMPLEMENTED TYPE STRING" ) {
		utility_exit_with_message("Can't map derived ResLvlTaskOperation with unimplemented type() method.");
	}
	rlto_map_[ type ] = rlto;
}

bool ResLvlTaskOperationFactory::has_type( std::string const & type ) const
{
	return ( rlto_map_.find( type ) != rlto_map_.end() );
}

///@brief return new ResLvlTaskOperation by key lookup in rlto_map_ (new ResLvlTaskOperation parses Tag if provided)
ResLvlTaskOperationOP
ResLvlTaskOperationFactory::newRLTO( std::string const & type ) const
{
	RLTO_Map::const_iterator iter( rlto_map_.find( type ) );
	if ( iter != rlto_map_.end() ) {
		ResLvlTaskOperationOP rlto( iter->second->clone() );
		return rlto;
	} else {
		utility_exit_with_message( type + " is not known to the ResLvlTaskOperationFactory. ResLvlTaskOperations outside of core::pack::task::operation must be registered via the add_type method from elsewhere in the code." );
		return NULL;
	}
}

} //namespace operation
} //namespace task
} //namespace pack
} //namespace core
