// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/operation/TaskOperationFactory.hh
/// @brief
/// @author ashworth

#ifndef INCLUDED_core_pack_task_operation_TaskOperationFactory_HH
#define INCLUDED_core_pack_task_operation_TaskOperationFactory_HH

// Unit Headers
#include <core/pack/task/operation/TaskOperationFactory.fwd.hh>

// Package Headers
#include <core/pack/task/operation/TaskOperation.fwd.hh>
#include <core/pack/task/operation/ResLvlTaskOperation.fwd.hh>
#include <core/pack/task/operation/ResLvlTaskOperationFactory.fwd.hh>
#include <core/pack/task/operation/ResFilter.fwd.hh>
#include <core/pack/task/operation/ResFilterFactory.fwd.hh>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/Tag/Tag.fwd.hh>

// c++ headers
#include <string>
#include <map>

namespace core {
namespace pack {
namespace task {
namespace operation {

class TaskOperationFactory : public utility::pointer::ReferenceCount
{
public:
	typedef utility::pointer::ReferenceCount parent;
	typedef std::map< std::string, TaskOperationOP > TaskOperationMap;
	typedef utility::Tag::Tag Tag;
	typedef utility::Tag::TagPtr TagPtr;

public:
	TaskOperationFactory();
	virtual ~TaskOperationFactory();

	///@brief add a prototype, using its default type name as the map key
	void add_type( TaskOperationOP, std::string type = std::string() );
	bool has_type( std::string const & ) const;
	///@brief pass through to child factories
	void add_type( ResLvlTaskOperationOP, std::string type = std::string() );
	void add_type( ResFilterOP, std::string type = std::string() );
///@brief return new TaskOperation by key lookup in task_operation_map_ (new TaskOperation parses Tag if provided)
	TaskOperationOP newTaskOperation(
		std::string const &,
		TagPtr = boost::shared_ptr< Tag >()
	) const;

private:
	TaskOperationMap task_operation_map_;
	// These are pointers to (optional) factories for elements used by residue-specific TaskOperations
	// (such as OperateOnCertainResidues). They are included here to support one-stop construction for
	// convenience (currently just to support tag parsing).
	ResLvlTaskOperationFactoryOP rlto_factory_;
	ResFilterFactoryOP res_filter_factory_;

};

} //namespace operation
} //namespace task
} //namespace pack
} //namespace core

#endif
