// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/core/conformation/ResidueFactory.hh
/// @brief
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)


#ifndef INCLUDED_core_scoring_ScoreFunctionFactory_HH
#define INCLUDED_core_scoring_ScoreFunctionFactory_HH

#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/scoring/symmetry/SymmetricScoreFunction.fwd.hh>

#ifdef _WIN32 //VC++ needs full class declaration
#include <core/scoring/ScoreFunction.hh>
#endif
// #include <core/chemical/ResidueType.fwd.hh>
// #include <core/conformation/Conformation.fwd.hh>
// #include <core/conformation/Residue.fwd.hh>
// #include <core/chemical/AtomTypeSet.fwd.hh>
// #include <core/chemical/MMAtomTypeSet.fwd.hh>

namespace core {
namespace scoring {

/// @brief a collection of functions making a single score_function
class ScoreFunctionFactory
{
public:

	typedef core::scoring::symmetry::SymmetricScoreFunction SymmetricScoreFunction;

	/// creates score_function from a weights file in the database
	static
	ScoreFunctionOP
	create_score_function( std::string weights_tag );

	/// creates score_function from a weights file in the database
	static
	ScoreFunctionOP
	create_score_function( std::string weights_tag, std::string const & patch_tag );

private:
	/// @brief Applies user defined re-weighting from the options system. Reweights are applied as a
	/// factor of the original, so -rg_reweight 0.5 would result in half of the previously defined
	/// rg weight.
	static void apply_user_defined_reweighting_( core::scoring::ScoreFunctionOP scorefxn );

	static void load_weights_file( std::string weights_tag, ScoreFunctionOP scorefxn );

};

extern std::string const STANDARD_WTS;
extern std::string const SCORE13;
extern std::string const CENTROID_WTS;
extern std::string const SOFT_REP_WTS;
extern std::string const SOFT_REP_DESIGN_WTS;
extern std::string const DNA_INT_WTS;
extern std::string const DNA_INT_WTS_GB;
extern std::string const RNA_LORES_WTS;
extern std::string const RNA_HIRES_WTS;
extern std::string const RNA_LORES_PLUS_HIRES_WTS;

extern std::string const SCORE12_PATCH;
extern std::string const DOCK_PATCH;
extern std::string const DOCK_LOW_PATCH;



/// @brief A helper function which returns a scoring function owning pointer according to the
/// user's command line parameters -score:weights and -score:patch
/// By default it returns weights=standard and patch=score12
///
core::scoring::ScoreFunctionOP getScoreFunction();

} // namespace scoring
} // namespace core

#endif
