// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/UnfoldedStatePotential.hh
/// @brief  Unfolded state energies based on energies of residues in fragments, declaration (header) file
/// @author Ron Jacak (ronj@email.unc.edu)

#ifndef INCLUDED_core_scoring_UnfoldedStatePotential_HH
#define INCLUDED_core_scoring_UnfoldedStatePotential_HH

// Unit Headers
#include <core/scoring/UnfoldedStatePotential.fwd.hh>

// Package headers
#include <core/scoring/types.hh>

// Project headers
#include <core/chemical/AA.hh>
#include <core/scoring/EnergyMap.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// Utility headers
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>

namespace core {
namespace scoring {


/// @begin UnfoldedStatePotential
///
/// @remarks
/// making this a separate class because it relies on a database file. rather than putting the code to read the database file
/// in the energy method class, it seems like the design we're following is to have a class like this one that reads the file
/// and provides the lookup into the data structure holding the database information and a separate class for the energy method
/// implementation.
///
class UnfoldedStatePotential : public utility::pointer::ReferenceCount {

public:
	/// @brief ctor - calls the function which reads in the database file
	UnfoldedStatePotential();
	virtual ~UnfoldedStatePotential();

	/// @brief returns database energy for an aa in the unfolded state
	void
	unfolded_state_energy( chemical::AA const &, scoring::EnergyMap & e ) const;

	/// @brief returns the unfolded state energy for the whole pose as an emap (i.e. broken up by score type)
	void
	pose_unfolded_state_energy( pose::Pose const & pose, scoring::EnergyMap & e ) const;


private:
	/// @brief Read the amino acid energy file
	void read_database_file();


private:
	///@brief Unfolded state energies by residue
	utility::vector1< scoring::EnergyMap > unfolded_energy_;


};

} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_UnfoldedStatePotential_HH
