// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/WaterAdductHBondPotential.hh
/// @brief
/// @author Jim Havranek


#ifndef INCLUDED_core_scoring_WaterAdductHBondPotential_HH
#define INCLUDED_core_scoring_WaterAdductHBondPotential_HH

#include <core/scoring/WaterAdductHBondPotential.fwd.hh>

#include <core/types.hh>
#include <core/scoring/types.hh>
#include <core/scoring/hbonds/HBondSet.hh>

#include <core/conformation/Residue.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/pack/rotamer_set/RotamerSet.fwd.hh>
#include <core/id/AtomID.fwd.hh>
#include <core/kinematics/DomainMap.fwd.hh>

#include <utility/vector1.hh>
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/ReferenceCount.hh>

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

namespace core {
namespace scoring {

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

class WaterAdductHBondPotential {
public:
	typedef conformation::Residue Residue;

public:
	/// ctor
	WaterAdductHBondPotential()
	{}

	///
	Real
	water_adduct_hbond_score(
		Residue const & rsd1,
		Residue const & rsd2
	) const;

	///
	Real
	h2o_hbond_score_1way(
		Residue const & h2o_rsd,
		Residue const & other_rsd
	) const;

	///
	void
	fill_h2o_hbond_set(
		pose::Pose const & pose,
		hbonds::HBondSet & hbond_set
	) const;

	void
	get_residue_residue_h2o_hbonds_1way(
		// input
		Residue const & don_rsd,
		Residue const & acc_rsd,
		int const & don_nb,
		int const & acc_nb,
		// output
		hbonds::HBondSet & hbond_set
	) const;

private:

};



} // scoring
} // core

#endif
