// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief

#ifndef INCLUDED_core_scoring_constraints_BindingSiteConstraint_HH
#define INCLUDED_core_scoring_constraints_BindingSiteConstraint_HH

// Package headers
#include <core/scoring/constraints/Constraint.hh>
#include <core/scoring/constraints/Func.hh>
#include <core/scoring/constraints/XYZ_Func.hh>
#include <core/scoring/ScoreType.hh>
#include <core/scoring/EnergyMap.hh>

// Project headers
#include <core/pose/Pose.hh>
#include <core/id/AtomID.hh>
#include <core/id/NamedAtomID.hh>

// ObjexxFCL headers
#include <ObjexxFCL/FArray2D.hh>

// C++ Headers
//#include <cstdlib>
//#include <iostream>
//#include <map>
//#include <utility>


namespace core {
namespace scoring {
namespace constraints {



class BindingSiteConstraint : public Constraint {
public:

	/// null constructor
	BindingSiteConstraint( ) :
			Constraint( atom_pair_constraint )  /// ? TO DO -- give own scoretype
	{ }

	/// ctor from atom list + input pose
	BindingSiteConstraint(
		utility::vector1< AtomID > const & atms,
		core::pose::Pose const &start_pose,
		ScoreType scoretype = atom_pair_constraint   /// ? TO DO -- give own scoretype
	);

	/// ctor from a vector of atom positions (in lieu of a pose)
	BindingSiteConstraint(
	  utility::vector1< AtomID > const & atms,
	  ObjexxFCL::FArray2D< core::Real >  tgt_pos,
	  ObjexxFCL::FArray2D< core::Real >  tgt_pos_centroid,
		ScoreType scoretype = atom_pair_constraint   /// ? TO DO -- give own scoretype
	);

	virtual ConstraintOP clone() const {
		return new BindingSiteConstraint( atms_, tgt_pos_, tgt_pos_centroid_ );
	}

	///
	void
	score( XYZ_Func const & xyz, EnergyMap const &, EnergyMap & emap ) const;

	// do some pre-scoring calculations
 	void setup_for_scoring( pose::Pose &pose, ScoreFunction const &scfxn ) const;

	// align the atoms
	//   ... placing a vector  -- from each atom to the the rotated >target< atoms -- in the database
	void pre_align( utility::vector1< numeric::xyzVector< core::Real > > const & templ_atms,
                  utility::vector1< bool > const & ) const;

	// call the setup_for_derivatives for each constraint
 	void setup_for_derivatives( pose::Pose &pose, ScoreFunction const &scfxn ) const;

	// atom deriv
	void
	fill_f1_f2(
		AtomID const & atom,
		conformation::Conformation const & conformation,
		Vector & F1,
	 	Vector & F2,
		EnergyMap const & weights
	) const;

	std::string type() const;

	///
	Size
	natoms() const;

	virtual
	ConstraintOP
	remap_resid( core::sequence::SequenceMapping const &seqmap ) const;

	///
	AtomID const &
	atom( Size const n ) const;

	void show( std::ostream& out ) const;

	void show_def( std::ostream& out, pose::Pose const& pose ) const;
	void read_def( std::istream& in, pose::Pose const& pose, FuncFactory const& func_factory );

	Size show_violations( std::ostream& out, pose::Pose const& pose, Size verbose_level, Real threshold = 1.0 ) const;

protected:
	void init( core::pose::Pose const &start_pose );

private:
	// data
	utility::vector1< AtomID > atms_;
	ObjexxFCL::FArray2D< core::Real >  tgt_pos_;
	ObjexxFCL::FArray2D< core::Real >  tgt_pos_centroid_;

	// map of pos->tgt in rotated struct
	static std::map< AtomID , numeric::xyzVector< core::Real > > rot_db;

	// database mapping constraints to RB transformations
	// static std::map< AtomID , ?? > transformDB;
};

}
}
}

#endif
