// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief


#ifndef INCLUDED_core_scoring_constraints_ConstraintForest_HH
#define INCLUDED_core_scoring_constraints_ConstraintForest_HH

// Unit headers
#include <core/scoring/constraints/ConstraintForest.fwd.hh>


// Package headers
#include <core/scoring/constraints/Constraint.hh>
#include <core/scoring/constraints/Constraints.hh>
//#include <core/scoring/constraints/BigBinConstraint.hh>
#include <protocols/jumping/PairingsList.hh>

// Project headers
#include <core/types.hh>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>
#include <numeric/random/random.hh>

//Utility Headers

// C++ Headers

namespace core {
namespace scoring {
namespace constraints {

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
// ConstraintForest
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

class ConstraintForest : public utility::pointer::ReferenceCount {
	public:
		typedef core::Real Real;
		typedef protocols::jumping::Pairing Pairing;
		typedef protocols::jumping::PairingsList PairingsList;

	  ConstraintForest();

    void read_forest(std::istream &in, core::pose::Pose &pose);

		friend std::ostream & operator<<(std::ostream &out, const ConstraintForest &forest);

		void generate_random_sample();
		ConstraintOPs get_constraints();
		PairingsList get_pairings();

	private:
	  std::map< std::string, ConstraintTreeOP > trees;

		ConstraintOPs constraints;
		PairingsList pairings;
};

class ConstraintTree : public utility::pointer::ReferenceCount {
	public:
		typedef core::Real Real;
		typedef protocols::jumping::Pairing Pairing;
		typedef protocols::jumping::PairingsList PairingsList;

	  ConstraintTree();

		void add_branch(Real prob, ConstraintBranchOP branch);

		void normalize();

		void generate_random_sample(ConstraintOPs &constraints, PairingsList &pairings);

		friend std::ostream & operator<<(std::ostream &out, const ConstraintForest &forest);

	private:
	  std::vector<ConstraintBranchOP> branches;
		std::vector<Real> probs;
};

std::ostream & operator<<(std::ostream &out, const ConstraintForest &forest);

class ConstraintBranch : public utility::pointer::ReferenceCount {
	public:
		typedef core::Real Real;
		typedef protocols::jumping::Pairing Pairing;
		typedef protocols::jumping::PairingsList PairingsList;

	  ConstraintBranch();

    void read_branch(std::istream &in, core::pose::Pose &pose);
		friend std::ostream & operator<<(std::ostream &out, const ConstraintBranch &branch);

		void get_constraints(ConstraintOPs &cons, PairingsList &pairs);

	private:
		ConstraintOPs constraints;
		PairingsList pairings;
    ConstraintForest forest;
};

std::ostream & operator<<(std::ostream &out, const ConstraintBranch &branch);

}
}
}

#endif
