// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/methods/FullatomCustomPairDistanceEnergy.hh
/// @brief  Custom atom pair distance energy
/// @author David E Kim


#ifndef INCLUDED_core_scoring_custom_pair_distance_FullatomCustomPairDistanceEnergy_HH
#define INCLUDED_core_scoring_custom_pair_distance_FullatomCustomPairDistanceEnergy_HH

// Unit Headers
#include <core/scoring/custom_pair_distance/FullatomCustomPairDistanceEnergy.fwd.hh>

// Package headers

// Project headers
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/methods/ContextIndependentTwoBodyEnergy.hh>
#include <core/scoring/constraints/Func.hh>

#include <core/chemical/ResidueType.fwd.hh>
#include <core/util/datacache/CacheableData.hh>

// Utility headers
#include <utility/OrderedTuple.hh>
#include <utility/fixedsizearray1.hh>
#include <numeric/interpolation/Histogram.hh>

namespace core {
namespace scoring {
namespace custom_pair_distance {

struct atoms_and_func_struct
{
	Size resA_atom_index_;
	Size resB_atom_index_;
	DistanceFuncCOP	func_;
};

struct resatom_and_func_struct
{
	Size res_index_;
	Size atom_index_;
	DistanceFuncCOP func_;
};

///
class FullatomCustomPairDistanceEnergy : public methods::ContextIndependentTwoBodyEnergy {
public:
	typedef methods::ContextIndependentTwoBodyEnergy parent;

public:
	typedef utility::fixedsizearray1< Size, 2 > ResAtomIndex;
	typedef utility::OrderedTuple< ResAtomIndex > ResAtomIndexTuple;
	typedef std::map< ResAtomIndexTuple, std::list< resatom_and_func_struct > > ResAtomIndexFuncMap;

	typedef utility::fixedsizearray1< chemical::ResidueTypeCAP, 2 > ResTypePair;
	typedef utility::OrderedTuple< ResTypePair > ResTypePairTuple;
	typedef std::map< ResTypePairTuple, std::list< atoms_and_func_struct > > PairFuncMap;

	///
	FullatomCustomPairDistanceEnergy();

	FullatomCustomPairDistanceEnergy( FullatomCustomPairDistanceEnergy const & src );

	/// clone
	virtual
	methods::EnergyMethodOP
	clone() const;


	/////////////////////////////////////////////////////////////////////////////
	// scoring
	/////////////////////////////////////////////////////////////////////////////

	// necessary pure virtual functions
	virtual
	void indicate_required_context_graphs( utility::vector1< bool > & /*context_graphs_required*/ ) const {}

	virtual
	bool
	defines_intrares_energy( EnergyMap const & /*weights*/ ) const { return false; }

	virtual
	void
	eval_intrares_energy(
		conformation::Residue const &,
		pose::Pose const &,
		ScoreFunction const &,
		EnergyMap &
	) const {}

	virtual
	void
	residue_pair_energy(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2,
		pose::Pose const & pose,
		ScoreFunction const &,
		TwoBodyEnergyMap & emap
	) const;

	virtual
	Distance
	atomic_interaction_cutoff() const;

	virtual
	void
	setup_for_minimizing(
		pose::Pose & pose,
		ScoreFunction const & sfxn,
		optimization::MinimizerMap const & min_map
	) const;

	virtual
  void
  eval_atom_derivative(
    id::AtomID const & id,
    pose::Pose const & pose,
    kinematics::DomainMap const & domain_map,
    ScoreFunction const & sfxn,
    EnergyMap const & emap,
    Vector & F1,
    Vector & F2
  ) const;

private:

	void
	set_pair_and_func_map();

// DATA

private:

	PairFuncMap pair_and_func_map_;
	Real max_dis_;
};



// stolen from Spencer's centroid disulfide stuff
class DistanceFunc : public constraints::Func
{
public:
	DistanceFunc( std::string const name );
	virtual ~DistanceFunc();
	constraints::FuncOP clone() const { return new DistanceFunc( *this ); }
	virtual Real func( Real const ) const;
	virtual Real dfunc( Real const ) const;
	virtual Real max_dis() const;
	virtual Real min_dis() const;
private:
	numeric::interpolation::HistogramCOP<Real,Real>::Type scores_hist_;
};



class CacheableAtomPairFuncMap : public util::datacache::CacheableData
{
public:
	typedef utility::fixedsizearray1< Size, 2 > ResAtomIndex;
	typedef utility::OrderedTuple< ResAtomIndex > ResAtomIndexTuple;
	typedef std::map< ResAtomIndexTuple, std::list< resatom_and_func_struct > > ResAtomIndexFuncMap;

	CacheableAtomPairFuncMap(){};
	virtual ~CacheableAtomPairFuncMap(){};
	virtual util::datacache::CacheableDataOP clone() const { return new CacheableAtomPairFuncMap( *this ); }
	ResAtomIndexFuncMap & map() { return map_; }
	ResAtomIndexFuncMap const & map() const { return map_; }
private:
	ResAtomIndexFuncMap map_;
};


}
}
}


#endif
