// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#include <core/scoring/electron_density/util.hh>
//#include <core/util/Tracer.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/options/option.hh>
#include <core/options/after_opts.hh>

#include <numeric/xyz.functions.hh>

#include <iostream>

// option key includes

#include <core/options/keys/edensity.OptionKeys.gen.hh>

// C++ Headers

namespace core {
namespace scoring {
namespace electron_density {

/// @brief read density weights from the cmd line into the scorefunction
void add_dens_scores_from_cmdline_to_scorefxn( core::scoring::ScoreFunction &scorefxn ) {
	using namespace core::options;

	if ( option[ OptionKeys::edensity::sliding_window_wt ].user() ) {
		scorefxn.set_weight( core::scoring::elec_dens_window,
													 option[ OptionKeys::edensity::sliding_window_wt ]() );
	}
	if ( option[ OptionKeys::edensity::whole_structure_ca_wt ].user() ) {
		scorefxn.set_weight( core::scoring::elec_dens_whole_structure_ca,
													 option[ OptionKeys::edensity::whole_structure_ca_wt ]() );
	}
	if ( option[ OptionKeys::edensity::whole_structure_allatom_wt ].user() ) {
		scorefxn.set_weight( core::scoring::elec_dens_whole_structure_allatom,
													 option[ OptionKeys::edensity::whole_structure_allatom_wt ]() );
	}
}




} // namespace constraints
} // namespace scoring
} // namespace core
