// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_core_scoring_electron_density_util_HH
#define INCLUDED_core_scoring_electron_density_util_HH

#include <core/types.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <numeric/xyz.io.hh>

// C++ Headers

namespace core {
namespace scoring {
namespace electron_density {

/// @brief update scorefxn with density scores from commandline
void add_dens_scores_from_cmdline_to_scorefxn( core::scoring::ScoreFunction &scorefxn_  );

///@brief Helper function to find the best rotation to transform the vectors A1-B1 to vectors A2-B2
numeric::xyzMatrix< core::Real > alignVectorSets(
		numeric::xyzVector< core::Real > A1,
		numeric::xyzVector< core::Real > B1,
		numeric::xyzVector< core::Real > A2,
		numeric::xyzVector< core::Real > B2);

} // namespace constraints
} // namespace scoring
} // namespace core

#endif
