// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_core_scoring_etable_EtableOptions_HH
#define INCLUDED_core_scoring_etable_EtableOptions_HH

#include <core/scoring/types.hh>
#include <core/options/option.hh>

#include <core/util/Tracer.hh>

// option key includes

#include <core/options/keys/score.OptionKeys.gen.hh>


// ObjexxFCL Headers

// ObjexxFCL Headers

// C++ Headers

namespace core {
namespace scoring {
namespace etable {

class EtableOptions {

public:

	EtableOptions():
		max_dis( 6.0 ),
		bins_per_A2( 20 ),
		Wradius( 1.0 ),
		lj_switch_dis2sigma( 0.6 )
	{
		using namespace core::options;
		using namespace core::options::OptionKeys;
		max_dis = option[ score::fa_max_dis ];
		if( option[ score::no_smooth_etables ] && !option[ score::fa_max_dis ].user() ) {
			core::util::T("core.scoring.etable") << "no_smooth_etables requested and fa_max_dis not specified: using 5.5 as default" << std::endl;
			max_dis = 5.5;
		}
	}

	///////
	// data
public:

	Real max_dis;
	int bins_per_A2;
	Real Wradius;
	Real lj_switch_dis2sigma;

private:

};

} // etable
} // scoring
} // core
#endif

