// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/methods/RNAHackElecEnergy.hh
/// @brief  Electrostatics for RNA
/// @author Rhiju Das


#ifndef INCLUDED_core_scoring_hackelec_RNAHackElecEnergy_HH
#define INCLUDED_core_scoring_hackelec_RNAHackElecEnergy_HH

/// Unit Headers
#include <core/scoring/hackelec/RNAHackElecEnergy.fwd.hh>

/// Package Headers
#include <core/scoring/hackelec/HackElecEnergy.hh>


namespace core {
namespace scoring {
namespace hackelec {

///
class RNAHackElecEnergy : public HackElecEnergy  {
public:
	typedef HackElecEnergy parent;
	typedef ContextIndependentTwoBodyEnergy grandparent;

public:

	///
	RNAHackElecEnergy( methods::EnergyMethodOptions const & options );

	///
	RNAHackElecEnergy( RNAHackElecEnergy const & src );


	/// clone
	virtual
	methods::EnergyMethodOP
	clone() const;

	virtual
	void
	setup_for_derivatives( pose::Pose & pose, ScoreFunction const & ) const;

	virtual
	void
	setup_for_scoring( pose::Pose & pose, ScoreFunction const & ) const;

	///
	virtual
	void
	setup_for_packing( pose::Pose & pose, pack::task::PackerTask const & ) const;


	/// @brief overrides parent class implementation which would have
	/// created several tries
	virtual
	void
	prepare_rotamers_for_packing(
		pose::Pose const & pose,
		pack::rotamer_set::RotamerSet & set ) const;

	/// @brief overrides parent class implementation which would have
	/// updated a trie
	virtual
	void
	update_residue_for_packing( pose::Pose & pose, Size resid ) const;

	/////////////////////////////////////////////////////////////////////////////
	// scoring
	/////////////////////////////////////////////////////////////////////////////

	virtual
	void
	residue_pair_energy(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2,
		pose::Pose const & pose,
		ScoreFunction const &,
		TwoBodyEnergyMap & emap
	) const;

	virtual
	void
	eval_intrares_energy(
		conformation::Residue const &,
		pose::Pose const &,
		ScoreFunction const &,
		EnergyMap &
	) const {}

	//@brief overrides default rotamer/rotamer energy calculation
	// and overrides the parent class trie implementatoin
	virtual
	void
	evaluate_rotamer_pair_energies(
		pack::rotamer_set::RotamerSet const & set1,
		pack::rotamer_set::RotamerSet const & set2,
		pose::Pose const & pose,
		ScoreFunction const & sfxn,
		EnergyMap const & weights,
		ObjexxFCL::FArray2D< pack::PackerEnergy > & energy_table
	) const;


	//@brief overrides default rotamer/background energy calculation
	// and overrides the parent class trie implementatoin
	virtual
	void
	evaluate_rotamer_background_energies(
		pack::rotamer_set::RotamerSet const & set,
		conformation::Residue const & residue,
		pose::Pose const & pose,
		ScoreFunction const & sfxn,
		EnergyMap const & weights,
		utility::vector1< pack::PackerEnergy > & energy_vector
	) const;


 	virtual
 	void
 	eval_atom_derivative(
 		id::AtomID const & atom_id,
 		pose::Pose const & pose,
		kinematics::DomainMap const & domain_map,
 		ScoreFunction const &,
 		EnergyMap const & weights,
 		Vector & F1,
 		Vector & F2
 	) const;

	virtual
	bool
	defines_intrares_energy( EnergyMap const & /*weights*/ ) const { return false; }

	virtual
	void indicate_required_context_graphs( utility::vector1< bool > & context_graphs_required ) const;

public:


	Real
	residue_pair_energy_RNA(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2,
		TwoBodyEnergyMap & emap
	) const;

	void
	eval_atom_derivative_RNA(
	   conformation::Residue const & rsd1,
		 Size const & i,
		 conformation::Residue const & rsd2,
		 EnergyMap const & weights,
		 Vector & F1,
		 Vector & F2
	) const;

};


}
}
}

#endif
