// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file core/scoring/hbonds/HBondOptions.fwd.hh
/// @brief forward header for HBondOptions class
/// @author Matthew O'Meara

#ifndef INCLUDED_core_scoring_hbonds_HBondOptions_FWD_HH
#define INCLUDED_core_scoring_hbonds_HBondOptions_FWD_HH

#include <utility/pointer/owning_ptr.hh>

namespace core{
namespace scoring{
namespace hbonds{

class HBondOptions;

typedef utility::pointer::owning_ptr< HBondOptions > HBondOptionsOP;
typedef utility::pointer::owning_ptr< HBondOptions const > HBondOptionsCOP;

} //hbonds
} //scoring
} //core

#endif // INCLUDED_core_scoring_hbonds_HBondOptions_FWD_HH
