// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   core/scoring/hbonds/EnergyMethodOptions.hh
/// @brief  HBondOptions class, holds the options for the hbond energy function
/// @author Matthew O'Meara

/// @detail
/// To add an additional option for hydrogen bonds do the following:
/// 1) add it to the default constructor
/// 2) add it to the copy constructor
/// 3) add a getter and a setter
/// 4) add it to operator==
/// 5) add it to the private data
/// 6) add it to HBondOptions::show


#ifndef INCLUDE_core_scoring_hbonds_HBondOptions_HH
#define INCLUDE_core_scoring_hbonds_HBondOptions_HH

#include <core/scoring/hbonds/HBondOptions.fwd.hh>
#include <utility/pointer/ReferenceCount.hh>

namespace core {
namespace scoring {
namespace hbonds {

class HBondOptions : public utility::pointer::ReferenceCount {
public:

  HBondOptions();

	~HBondOptions();

  /// copy constructor
  HBondOptions( HBondOptions const & src );

  /// copy operator
	HBondOptions const &
  operator=( HBondOptions const & src );

  ///
  bool const &
  exclude_DNA_DNA() const;

  ///
  void
  exclude_DNA_DNA( bool const & setting );

  ///
  bool const &
  use_hb_env_dep_DNA() const;

  ///
  void
  use_hb_env_dep_DNA( bool const & setting );

  ///
  bool const &
  use_hb_env_dep() const;

  ///
  void
  use_hb_env_dep( bool const & setting );

  ///
  bool const &
  smooth_hb_env_dep() const;

  ///
  void
  smooth_hb_env_dep( bool const & setting );

  ///
  bool const &
  decompose_bb_hb_into_pair_energies() const;

  ///
  void
  decompose_bb_hb_into_pair_energies( bool const & setting );

  friend
  bool
  operator==( HBondOptions const & a, HBondOptions const & b );

  friend
  bool
  operator!=( HBondOptions const & a, HBondOptions const & b );

	friend
	std::ostream &
	operator<< ( std::ostream & out,  const HBondOptions & options );

  ///
  void
  show( std::ostream & out ) const;

private:

  bool exclude_DNA_DNA_;
  bool use_hb_env_dep_;
	bool use_hb_env_dep_DNA_;
  bool smooth_hb_env_dep_;
  bool decompose_bb_hb_into_pair_energies_;
};


} // hbonds
} // scoring
} // core


#endif // INCLUDE_core_scoring_hbonds_HBondOptions_HH
