// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

// Rosetta Headers
#include <core/scoring/hbonds/constants.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray2D.hh>

// Using

namespace core {
namespace scoring {
namespace hbonds {

void
HBeval_lookup_initializer( ObjexxFCL::FArray2D<HBEvalType> & hbe )
{
	hbe(hbacc_NO  , hbdon_NO) = hbe_NONE; hbe(hbacc_NO  , hbdon_BBN) = hbe_NONE ; hbe(hbacc_NO  , hbdon_SC) = hbe_NONE  ;
	hbe(hbacc_BB  , hbdon_NO) = hbe_NONE; hbe(hbacc_BB  , hbdon_BBN) = hbe_BB   ; hbe(hbacc_BB  , hbdon_SC) = hbe_BSC   ;
	hbe(hbacc_SP2 , hbdon_NO) = hbe_NONE; hbe(hbacc_SP2 , hbdon_BBN) = hbe_SP2B ; hbe(hbacc_SP2 , hbdon_SC) = hbe_SP2SC ;
	hbe(hbacc_SP3 , hbdon_NO) = hbe_NONE; hbe(hbacc_SP3 , hbdon_BBN) = hbe_SP3B ; hbe(hbacc_SP3 , hbdon_SC) = hbe_SP3SC ;
	hbe(hbacc_RING, hbdon_NO) = hbe_NONE; hbe(hbacc_RING, hbdon_BBN) = hbe_RINGB; hbe(hbacc_RING, hbdon_SC) = hbe_RINGSC;
}

ObjexxFCL::FArray2D<HBEvalType> const HBeval_lookup( hbacc_MAX, hbdon_MAX, HBeval_lookup_initializer);



} // hbonds
} // scoring
} // core

