// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/types.hh
/// @brief  core::scoring package type declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_scoring_hbonds_constants_HH
#define INCLUDED_core_scoring_hbonds_constants_HH


// Project headers
#include <core/scoring/hbonds/types.hh>
//#include <core/conformation/types.hh>

// ObjexxFCL headers
#include <ObjexxFCL/FArray2D.hh>


namespace core {
namespace scoring {
namespace hbonds {


int const SHORT_RANGE_CUTOFF = { 4 };

int const GENERIC_SHORTRANGE_SEQ_CUTOFF = { 1 };

//car cutoffs defining what is a hbond
static core::Real const MAX_R = { 3.0 };
static core::Real const MIN_R = { 1.4 }; // AH distance
	//static core::Real const MIN_xH = { -0.5 }; // cos( radians( 180.0 - 90.0 ) )  // psi cutoff
static core::Real const MIN_xH = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // psi cutoff
static core::Real const MIN_xD = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // theta cutoff
static core::Real const MAX_xH = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // psi cutoff
static core::Real const MAX_xD = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // theta cutoff
static core::Real const R_INTERP_EDGE = { 2.1 };
static core::Real const ANGLE_INTERP_EDGE = { .05 };

static core::Real const MIN_R2 = { MIN_R * MIN_R };
static core::Real const MAX_R2 = { MAX_R * MAX_R };

static core::Real const MAX_HB_ENERGY = { 0.0 }; // at and above this cutoff, not considered a hbond

//car for sidechain hbonds, separate polynomials exist for short and long
//car distances  // JSS This makes their computation rather baroque...
//JSS Need these to be static core::Reals so I can initialize classes with them
static core::Real const SWITCH_DIS = { 2.1 }; // distance cutoff for sidechain hbonds tables
static core::Real const INTERP_RANGE = { 0.2 };
 // interpolate if AH dist falls between switch +/- range
static core::Real const INTERP_MIN = { SWITCH_DIS - INTERP_RANGE };
static core::Real const INTERP_MAX = { SWITCH_DIS + INTERP_RANGE };


extern ObjexxFCL::FArray2D<HBEvalType> const HBeval_lookup;

// Now these are options:
//static bool const use_W_hb_env_dep_tk( false );
//static bool const smooth_env_dep_hb( true );


} // namespace hbonds
} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_types_HH
