// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/types.hh
/// @brief  core::scoring package type declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_scoring_hbonds_create_poly_HH
#define INCLUDED_core_scoring_hbonds_create_poly_HH


// Project headers
//#include <core/types.hh>
//#include <core/conformation/types.hh>

// ObjexxFCL headers
//#include <ObjexxFCL/CArray.fwd.hh>
//#include <ObjexxFCL/CPArray.fwd.hh>
//#include <ObjexxFCL/FArray.fwd.hh>


namespace core {
namespace scoring {
namespace hbonds {


//JSS Useful #defines to set up hbonds_geom scoring polynomials of the form
// name(/*in*/ double x, /*out*/ double &value, double &deriv);
// You shouldn't have to look at these; The idea is to auto-generate
// the calls to create_poly#() using matlab scripts to fit polynomials.
// POLY_CLIPVAL is the polynomial value outside of clip interval [xmin xmax]
// See hbonds_geom.cc for more comments.
#define POLY_CLIPVAL 0.0
#define create_poly8(name, xmin, xmax, c7, c6, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c7; value = value*x+c6; deriv = deriv*x+value; value = value*x+c5; deriv = deriv*x+value; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly7(name, xmin, xmax, c6, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c6; value = value*x+c5; deriv = deriv*x+value; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly6(name, xmin, xmax, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c5; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly5(name, xmin, xmax, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c4; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly4(name, xmin, xmax, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c3; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly3(name, xmin, xmax, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c2; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly2(name, xmin, xmax, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c1; value = value*x+c0; }


} // namespace hbonds
} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_types_HH
