// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_core_scoring_hbonds_hbonds_HH
#define INCLUDED_core_scoring_hbonds_hbonds_HH

#include <core/scoring/hbonds/types.hh>
#include <core/scoring/hbonds/HBondSet.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/scoring/EnergyMap.fwd.hh>
#include <core/conformation/Residue.fwd.hh>

#include <core/pose/Pose.fwd.hh>


namespace core {
namespace scoring {
namespace hbonds {


// Undefinded, comented out to make python bindings complile
/* void
hbond_energy(
	pose::Pose & pose,
	ScoreFunction const & scorefxn
); */


void
fill_hbond_set(
	pose::Pose const & pose,
	bool const calculate_derivative,
	HBondSet & hbond_set,
	bool const backbone_only = false
);


void
get_hbond_energies(
	HBondSet const & hbond_set,
	Real & sr_bb_hbenergy, // short range bb-bb total
	Real & lr_bb_hbenergy, // long range bb-bb total
	Real & bb_sc_hbenergy, // sc-bb total
	Real & sc_hbenergy // sc-sc total
);

void
get_hbond_energies_excl(
	HBondSet const & hbond_set,
	Real & sr_bb_hbenergy, // short range bb-bb total
	Real & lr_bb_hbenergy, // long range bb-bb total
	Real & bb_sc_hbenergy, // sc-bb total
	Real & sc_hbenergy, // sc-sc total
	utility::vector1< core::Size > exclude_list
);


void
get_residue_residue_hbonds_1way(
	// input
	conformation::Residue const & don_rsd,
	conformation::Residue const & acc_rsd,
	int const don_nb,
	int const acc_nb,
	bool const evaluate_derivative,
	bool const backbone_only,
	// output
	HBondSet & hbond_set
);

void
get_residue_residue_hbond_energy(
	// input
	conformation::Residue const & rsd1,
	conformation::Residue const & rsd2,
	int const nb1,
	int const nb2,
	bool const bb1_is_donor,
	bool const bb1_is_acceptor,
	bool const bb2_is_donor,
	bool const bb2_is_acceptor,
	bool const exclude_bb_bb,
	bool const use_hb_env_dep,
	bool const use_hb_env_dep_DNA,
	bool const smooth_hb_env_dep,
	// energies -- zeroed
	Real & scE,
	Real & sr_bbE,
	Real & lr_bbE,
	Real & bb_scE
);

/// @brief variant get_residue pair energy where sidechain/backbone
/// hydrogen bond energies are separated out by residue of origin.
void
get_residue_residue_hbond_energy(
	// input
	conformation::Residue const & rsd1,
	conformation::Residue const & rsd2,
	int const nb1,
	int const nb2,
	bool const bb1_is_donor,
	bool const bb1_is_acceptor,
	bool const bb2_is_donor,
	bool const bb2_is_acceptor,
	bool const exclude_bb_bb,
	bool const use_hb_env_dep,
	bool const use_hb_env_dep_DNA,
	bool const smooth_hb_env_dep,
	// energies -- zeroed
	Real & scE,
	Real & sr_bbE,
	Real & lr_bbE,
	Real & bb1_sc2_E,
	Real & bb2_sc1_E
);


void
get_residue_residue_hbond_energy_1way(
	// input
	conformation::Residue const & don_rsd,
	conformation::Residue const & acc_rsd,
	int const don_nb,
	int const acc_nb,
	bool const don_bb_hbond_exists,
	bool const acc_bb_hbond_exists,
	bool const exclude_bb_bb,
	bool const use_hb_env_dep,
	bool const use_hb_env_dep_DNA,
	bool const smooth_hb_env_dep,
	// energies -- not zeroed, just accumulated
	Real & scE,
	Real & sr_bbE,
	Real & lr_bbE,
	Real & bb_scE,
	Real & sc1_bb2_scdon,
	Real & sc2_bb1_scacc
);

Energy
get_sc_sc_hbond_energy(
	conformation::Residue const & rsd1,
	conformation::Residue const & rsd2,
	int const nb1,
	int const nb2,
	bool const use_hb_env_dep,
	bool const use_hb_env_dep_DNA,
	bool const smooth_hb_env_dep
);



Real
get_environment_dependent_weight(
	HBEvalType const & hbe_type,
	int const don_nb,
	int const acc_nb,
	bool const smooth_hb_env_dep = true
);

// Undefinded, comented out to make python bindings complile
/* Real
score_function_hb_eval_type_weight(
	HBEvalType const & hbe_type,
	ScoreFunction const & scorefxn
); */

Real
hb_eval_type_weight(
	HBEvalType const & hbe_type,
	EnergyMap const & weights
);


bool
nonzero_hbond_weight( ScoreFunction const & scorefxn );


void
get_atom_hbond_derivative(
	id::AtomID const & atom,
	HBondSet const & hbond_set,
	EnergyMap const & weights,
	Vector & f1,
	Vector & f2
);


}
}
}

#endif

