// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/methods/MMTorsionEnergy.hh
/// @brief  molecular mechanics torsion energy
/// @author P. Douglas Renfrew (renfrew@unc.edu)

#ifndef INCLUDED_core_scoring_methods_MMTorsionEnergy_HH
#define INCLUDED_core_scoring_methods_MMTorsionEnergy_HH

// Unit headers
#include <core/scoring/methods/MMTorsionEnergy.fwd.hh>
#include <core/mm/MMTorsionScore.hh>
#include <core/mm/MMTorsionLibrary.hh>

// Package headers
#include <core/scoring/methods/ContextIndependentTwoBodyEnergy.hh>

// Project headers
#include <core/pose/Pose.fwd.hh>
#include <core/types.hh>

// C++ headers
#include <iostream>

namespace core {
namespace scoring {
namespace methods {

class MMTorsionEnergy : public ContextIndependentTwoBodyEnergy  {
public:
	typedef ContextIndependentTwoBodyEnergy  parent;
public:

	/// ctor
	MMTorsionEnergy();

	/// clone
	virtual
	EnergyMethodOP
	clone() const;

	/// setup for packing
	virtual
	void
	setup_for_packing( pose::Pose & pose, pack::task::PackerTask const & ) const;

	/// setup for scoring
	virtual
	void
	setup_for_scoring( pose::Pose & pose, ScoreFunction const & ) const;

	/// setup for derivatives
	virtual
	void
	setup_for_derivatives( pose::Pose & pose, ScoreFunction const & ) const;

	///
	virtual
	void
	residue_pair_energy(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2,
		pose::Pose const &,
		ScoreFunction const &,
		TwoBodyEnergyMap & emap
	) const;

	virtual
	bool
	defines_intrares_energy( EnergyMap const & ) const ;

	virtual
	void
	eval_intrares_energy(
		conformation::Residue const & rsd,
		pose::Pose const &,
		ScoreFunction const &,
		EnergyMap & emap
	) const;

	/// @brief evaluate xyz derivatives (and not DOF derivatives)
	/// for a particular atom.
	virtual
	void
	eval_atom_derivative(
		id::AtomID const & id,
		pose::Pose const & pose,
		kinematics::DomainMap const & domain_map,
		ScoreFunction const & sfxn,
		EnergyMap const & emap,
		Vector & F1,
		Vector & F2
	) const;


	/// @brief MMTorsionEnergy does not have an atomic interation threshold
	virtual
	Distance
	atomic_interaction_cutoff() const;

	/// @brief MMTorsionEnergy is context independent; indicates that no
	/// context graphs are required
	virtual
	void indicate_required_context_graphs( utility::vector1< bool > & ) const;

private:
	mm::MMTorsionScore potential_;

};

} // namespace methods
} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_methods_MMTorsionEnergy_HH
