// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

 //////////////////////////////////////////////
 /// @begin
 ///
 /// @file core/scoring/TensorsOptimizer.hh
 ///
 /// @brief
 ///
 /// @detailed
 ///
 /// @param
 ///
 /// @return
 ///
 /// @remarks
 ///
 /// @references
 ///
 /// @authorsv Christophe Schmitz
 ///
 /// @last_modified June 2009
 ////////////////////////////////////////////////


#ifndef INCLUDED_core_scoring_methods_PCS_TensorsOptimizer_HH
#define INCLUDED_core_scoring_methods_PCS_TensorsOptimizer_HH

// Package headers
#include <core/scoring/methods/PCS/PseudocontactShiftData.fwd.hh>
// Project headers
#include <core/optimization/Multifunc.hh>

// Utility headers

// Numeric headers

// Objexx headers

// C++ headers


namespace core{
namespace scoring{
namespace methods{
namespace PCS{


class TensorsOptimizer : public core::optimization::Multifunc {

public:
	PCS_data const & pcs_d_;

  TensorsOptimizer();

  TensorsOptimizer(PCS_data const & pcs_d);

  virtual
  ~TensorsOptimizer();

  // @brief OptE func
  virtual
  core::Real
  operator ()( optimization::Multivec const & vars ) const;

  /// @brief OptE dfunc
  virtual
  void
  dfunc(optimization::Multivec const & vars,
	optimization::Multivec & dE_dvars
	) const;


	//	void
	//	dfunc_test(optimization::Multivec const & vars) const;

private:


}; // TensorsOptimizer



}//namespace PCS
}//namespace methods
}//namespace scoring
}//namespace core

#endif
